/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.geojson.Position;
import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.query.Shape;
import dev.morphia.sofia.Sofia;
import java.util.Locale;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

class ShapeCodec
implements Codec<Shape> {
    ShapeCodec() {
    }

    @Override
    public Shape decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException(Sofia.encodingOnly(new Locale[0]));
    }

    @Override
    public void encode(BsonWriter writer, Shape value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> ExpressionHelper.array(writer, value.getGeometry(), () -> {
            for (Point point : value.getPoints()) {
                this.encodePosition(writer, point.getCoordinates());
            }
        }));
    }

    @Override
    public Class<Shape> getEncoderClass() {
        return Shape.class;
    }

    private void encodePosition(BsonWriter writer, Position value) {
        writer.writeStartArray();
        for (double number : value.getValues()) {
            writer.writeDouble(number);
        }
        writer.writeEndArray();
    }
}

