/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.ArrayCodec;
import dev.morphia.mapping.codec.ByteWrapperArrayCodec;
import dev.morphia.mapping.codec.CenterCodec;
import dev.morphia.mapping.codec.ClassCodec;
import dev.morphia.mapping.codec.KeyCodec;
import dev.morphia.mapping.codec.LegacyQueryCodec;
import dev.morphia.mapping.codec.LocaleCodec;
import dev.morphia.mapping.codec.MorphiaDateCodec;
import dev.morphia.mapping.codec.MorphiaLocalDateTimeCodec;
import dev.morphia.mapping.codec.MorphiaLocalTimeCodec;
import dev.morphia.mapping.codec.MorphiaMapCodec;
import dev.morphia.mapping.codec.ObjectCodec;
import dev.morphia.mapping.codec.ShapeCodec;
import dev.morphia.mapping.codec.TypedArrayCodec;
import dev.morphia.mapping.codec.URICodec;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.codecs.Codec;
import org.bson.codecs.MapCodec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

public class MorphiaTypesCodecProvider
implements CodecProvider {
    private final Mapper mapper;
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();

    public MorphiaTypesCodecProvider(Mapper mapper) {
        this.mapper = mapper;
        this.addCodec(new MorphiaDateCodec(mapper));
        this.addCodec(new MorphiaMapCodec(mapper));
        this.addCodec(new MorphiaLocalDateTimeCodec(mapper));
        this.addCodec(new MorphiaLocalTimeCodec());
        this.addCodec(new ClassCodec());
        this.addCodec(new CenterCodec());
        this.addCodec(new HashMapCodec());
        this.addCodec(new KeyCodec(mapper));
        this.addCodec(new LocaleCodec());
        this.addCodec(new ObjectCodec(mapper));
        this.addCodec(new ShapeCodec());
        this.addCodec(new URICodec());
        this.addCodec(new ByteWrapperArrayCodec());
        this.addCodec(new LegacyQueryCodec(mapper));
        List.of(Boolean.TYPE, Boolean.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class).forEach(c -> this.addCodec(new TypedArrayCodec((Class)c, mapper)));
    }

    protected <T> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        Codec<?> codec = this.codecs.get(clazz);
        if (codec != null) {
            return codec;
        }
        if (AbstractMap.class.isAssignableFrom(clazz)) {
            return this.get(Map.class, registry);
        }
        if (clazz.isArray() && !clazz.getComponentType().equals(Byte.TYPE)) {
            return new ArrayCodec(this.mapper, clazz);
        }
        return null;
    }

    private static class HashMapCodec
    extends MapCodec {
        private HashMapCodec() {
        }

        @Override
        public Class<Map<String, Object>> getEncoderClass() {
            return HashMap.class;
        }
    }
}

