/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.Conversions;
import java.util.Map;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.MapCodec;

public class MorphiaMapCodec
extends MapCodec {
    private final Mapper mapper;

    MorphiaMapCodec(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void encode(BsonWriter writer, Map map, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                writer.writeName(Conversions.convert(key, String.class));
                if (entry.getValue() == null) {
                    writer.writeNull();
                    continue;
                }
                Codec<?> codec = this.mapper.getCodecRegistry().get(entry.getValue().getClass());
                codec.encode(writer, entry.getValue(), encoderContext);
            }
        });
    }
}

