/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.Datastore;
import dev.morphia.annotations.PostLoad;
import dev.morphia.annotations.PostPersist;
import dev.morphia.annotations.PreLoad;
import dev.morphia.annotations.PrePersist;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.MorphiaCollectionPropertyCodecProvider;
import dev.morphia.mapping.codec.MorphiaInstanceCreator;
import dev.morphia.mapping.codec.MorphiaMapPropertyCodecProvider;
import dev.morphia.mapping.codec.MorphiaPropertyCodecProvider;
import dev.morphia.mapping.codec.pojo.EntityDecoder;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.LifecycleDecoder;
import dev.morphia.mapping.codec.pojo.LifecycleEncoder;
import dev.morphia.mapping.codec.pojo.MorphiaCodec;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PropertyCodecProvider;

public class MorphiaCodecProvider
implements CodecProvider {
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();
    private final Mapper mapper;
    private final List<PropertyCodecProvider> propertyCodecProviders = new ArrayList<PropertyCodecProvider>();
    private final Datastore datastore;

    public MorphiaCodecProvider(Mapper mapper, Datastore datastore) {
        this.datastore = datastore;
        this.mapper = mapper;
        this.propertyCodecProviders.addAll(List.of(new MorphiaMapPropertyCodecProvider(), new MorphiaCollectionPropertyCodecProvider()));
        ServiceLoader<MorphiaPropertyCodecProvider> providers = ServiceLoader.load(MorphiaPropertyCodecProvider.class);
        providers.forEach(this.propertyCodecProviders::add);
    }

    @Override
    public <T> Codec<T> get(Class<T> type2, CodecRegistry registry) {
        MorphiaCodec codec = (MorphiaCodec)this.codecs.get(type2);
        if (codec == null && (this.mapper.isMapped(type2) || this.mapper.isMappable(type2))) {
            EntityModel model = this.mapper.getEntityModel(type2);
            codec = new MorphiaCodec(this.datastore, model, this.propertyCodecProviders, this.mapper.getDiscriminatorLookup(), registry);
            if (model.hasLifecycle(PostPersist.class) || model.hasLifecycle(PrePersist.class) || this.mapper.hasInterceptors()) {
                codec.setEncoder(new LifecycleEncoder(codec));
            }
            if (model.hasLifecycle(PreLoad.class) || model.hasLifecycle(PostLoad.class) || this.mapper.hasInterceptors()) {
                codec.setDecoder(new LifecycleDecoder(codec));
            }
            this.codecs.put(type2, codec);
        }
        return codec;
    }

    public <T> Codec<T> getRefreshCodec(final T entity, CodecRegistry registry) {
        EntityModel model = this.mapper.getEntityModel(entity.getClass());
        return new MorphiaCodec<T>(this.datastore, model, this.propertyCodecProviders, this.mapper.getDiscriminatorLookup(), registry){

            @Override
            protected EntityDecoder getDecoder() {
                return new EntityDecoder(this){

                    @Override
                    protected MorphiaInstanceCreator getInstanceCreator() {
                        return new MorphiaInstanceCreator(){

                            public T getInstance() {
                                return entity;
                            }

                            @Override
                            public void set(Object value, PropertyModel model) {
                                model.getAccessor().set(entity, value);
                            }
                        };
                    }
                };
            }
        };
    }
}

