/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.mapping.codec.EnumCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.codecs.pojo.TypeWithTypeParameters;

final class EnumPropertyCodecProvider
implements PropertyCodecProvider {
    private final CodecRegistry codecRegistry;

    EnumPropertyCodecProvider(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    @Override
    public <T> Codec<T> get(TypeWithTypeParameters<T> type2, PropertyCodecRegistry propertyCodecRegistry) {
        Class<T> clazz = type2.getType();
        if (Enum.class.isAssignableFrom(clazz)) {
            try {
                return this.codecRegistry.get(clazz);
            }
            catch (CodecConfigurationException e) {
                return new EnumCodec<T>(clazz);
            }
        }
        return null;
    }
}

