/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import com.mongodb.lang.Nullable;
import dev.morphia.mapping.MappingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Conversions {
    private static final Logger LOG = LoggerFactory.getLogger(Conversions.class);
    private static final Map<Class<?>, Map<Class<?>, Function<?, ?>>> CONVERSIONS = new HashMap();

    private Conversions() {
    }

    private static void registerStringConversions() {
        Conversions.register(String.class, BigDecimal.class, BigDecimal::new);
        Conversions.register(String.class, ObjectId.class, ObjectId::new);
        Conversions.register(String.class, Character.class, s2 -> {
            if (s2.length() == 1) {
                return Character.valueOf(s2.charAt(0));
            }
            if (s2.isEmpty()) {
                return Character.valueOf('\u0000');
            }
            throw new MappingException("Could not convert String to char: " + s2);
        });
        Conversions.register(String.class, Boolean.class, Boolean::parseBoolean);
        Conversions.register(String.class, Byte.class, Byte::parseByte);
        Conversions.register(String.class, Double.class, Double::parseDouble);
        Conversions.register(String.class, Integer.class, Integer::valueOf);
        Conversions.register(String.class, Long.class, Long::parseLong);
        Conversions.register(String.class, Float.class, Float::parseFloat);
        Conversions.register(String.class, Short.class, Short::parseShort);
        Conversions.register(String.class, URI.class, str -> URI.create(str.replace("%46", ".")));
        Conversions.register(String.class, UUID.class, UUID::fromString);
    }

    public static <S, T> void register(Class<S> source, Class<T> target, Function<S, T> function) {
        Conversions.register(source, target, function, null);
    }

    @Nullable
    public static <T> T convert(@Nullable Object value, Class<T> target) {
        if (value == null) {
            return (T)Conversions.convertNull(target);
        }
        Class<?> fromType = value.getClass();
        if (fromType.equals(target)) {
            return (T)value;
        }
        Function function = (Function)CONVERSIONS.computeIfAbsent(fromType, f -> new HashMap()).get(target);
        if (function == null) {
            if (target.equals(String.class)) {
                return (T)value.toString();
            }
            if (target.isEnum() && fromType.equals(String.class)) {
                return Enum.valueOf(target, (String)value);
            }
            return (T)value;
        }
        return (T)function.apply(value);
    }

    @Nullable
    private static Object convertNull(Class<?> toType) {
        if (Conversions.isNumber(toType)) {
            return 0;
        }
        if (Conversions.isBoolean(toType)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static <S, T> void register(Class<S> source, Class<T> target, Function<S, T> function, @Nullable String warning) {
        Function conversion = warning == null ? function : s2 -> {
            if (LOG.isWarnEnabled()) {
                LOG.warn(warning);
            }
            return function.apply(s2);
        };
        CONVERSIONS.computeIfAbsent(source, c -> new HashMap()).put(target, conversion);
    }

    private static boolean isNumber(Class<?> type2) {
        return type2.isPrimitive() && !type2.equals(Boolean.TYPE);
    }

    private static boolean isBoolean(Class<?> type2) {
        return type2.equals(Boolean.TYPE);
    }

    static {
        Conversions.registerStringConversions();
        Conversions.register(Binary.class, byte[].class, Binary::getData);
        Conversions.register(Date.class, Long.class, Date::getTime);
        Conversions.register(Date.class, Long.TYPE, Date::getTime);
        Conversions.register(Instant.class, Long.class, Instant::toEpochMilli);
        Conversions.register(Instant.class, Long.TYPE, Instant::toEpochMilli);
        Conversions.register(Double.class, Long.class, Double::longValue, "Converting a double value to a long.  Possible loss of precision.");
        Conversions.register(Double.class, Integer.class, Double::intValue, "Converting a double value to an int.  Possible loss of precision.");
        Conversions.register(Double.class, Float.class, Double::floatValue, "Converting a double value to a float.  Possible loss of precision.");
        Conversions.register(Integer.class, Byte.class, Integer::byteValue);
        Conversions.register(Long.class, Date.class, l -> Date.from(Instant.ofEpochMilli(l)));
        Conversions.register(Long.class, Double.class, Long::doubleValue);
        Conversions.register(Long.class, Float.class, Long::floatValue);
        Conversions.register(Float.class, Long.class, Float::longValue, "Converting a float value to a long.  Possible loss of precision.");
        Conversions.register(Float.class, Integer.class, Float::intValue, "Converting a float value to an int.  Possible loss of precision.");
        Conversions.register(URI.class, String.class, u -> {
            try {
                return u.toURL().toExternalForm().replace(".", "%46");
            }
            catch (MalformedURLException e) {
                throw new MappingException("Could not convert URI: " + u);
            }
        });
    }
}

