/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import org.bson.BsonBinary;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class ByteWrapperArrayCodec
implements Codec<Byte[]> {
    @Override
    public Byte[] decode(BsonReader reader, DecoderContext decoderContext) {
        return this.wrapper(reader.readBinaryData().getData());
    }

    @Override
    public void encode(BsonWriter writer, Byte[] value, EncoderContext encoderContext) {
        writer.writeBinaryData(new BsonBinary(this.primitive(value)));
    }

    @Override
    public Class<Byte[]> getEncoderClass() {
        return Byte[].class;
    }

    private byte[] primitive(Byte[] value) {
        byte[] array = new byte[value.length];
        for (int i2 = 0; i2 < value.length; ++i2) {
            if (value[i2] == null) continue;
            array[i2] = value[i2];
        }
        return array;
    }

    private Byte[] wrapper(byte[] value) {
        Byte[] array = new Byte[value.length];
        for (int i2 = 0; i2 < value.length; ++i2) {
            array[i2] = value[i2];
        }
        return array;
    }
}

