/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import com.mongodb.lang.Nullable;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.FieldAccessor;
import dev.morphia.mapping.codec.pojo.TypeData;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;

public class ArrayFieldAccessor
extends FieldAccessor {
    private final TypeData<?> typeData;
    private final Class<?> componentType;

    public ArrayFieldAccessor(TypeData<?> typeData, Field field) {
        super(field);
        this.typeData = typeData;
        this.componentType = field.getType().getComponentType();
    }

    @Override
    public void set(Object instance, Object value) {
        Object newValue = value;
        if (value.getClass().getComponentType() != this.componentType) {
            newValue = value instanceof List ? this.convert((List)value) : this.convert((Object[])value);
        }
        super.set(instance, newValue);
    }

    private Object convert(Object[] value) {
        Object newArray = Array.newInstance(this.componentType, value.length);
        for (int i2 = 0; i2 < value.length; ++i2) {
            Object convert = this.convert(value[i2], this.componentType);
            Array.set(newArray, i2, convert);
        }
        return newArray;
    }

    private Object convert(List value) {
        Object newArray = Array.newInstance(this.componentType, value.size());
        for (int i2 = 0; i2 < value.size(); ++i2) {
            Object converted = this.convert(value.get(i2), this.componentType);
            if (converted != null) {
                try {
                    Array.set(newArray, i2, converted);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Can't set %s with a value type of %s", this.getField(), converted.getClass()));
                }
            }
            throw new IllegalArgumentException(String.format("Can not convert '%s' to type '%s' ", value.get(i2), this.componentType.getName()));
        }
        return newArray;
    }

    @Nullable
    private Object convert(Object o, Class<?> type2) {
        if (o instanceof List) {
            List list = (List)o;
            Object newArray = Array.newInstance(type2.getComponentType(), list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object converted = this.convert(list.get(i2), type2.getComponentType());
                try {
                    Array.set(newArray, i2, converted);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Can't set %s with a value type of %s", this.getField(), converted.getClass()));
                }
            }
            return newArray;
        }
        return Conversions.convert(o, type2);
    }
}

