/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import com.mongodb.lang.Nullable;
import dev.morphia.mapping.Mapper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

class ArrayCodec
implements Codec<Object> {
    private final Class type;
    private final Mapper mapper;

    <T> ArrayCodec(Mapper mapper, Class type2) {
        this.mapper = mapper;
        this.type = type2;
    }

    @Override
    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
        writer.writeStartArray();
        int length = Array.getLength(value);
        for (int i2 = 0; i2 < length; ++i2) {
            Object element = Array.get(value, i2);
            if (element == null) {
                writer.writeNull();
                continue;
            }
            Codec<?> codec = this.mapper.getCodecRegistry().get(element.getClass());
            codec.encode(writer, element, encoderContext);
        }
        writer.writeEndArray();
    }

    @Override
    public Class<Object> getEncoderClass() {
        return null;
    }

    @Override
    public Object[] decode(BsonReader reader, DecoderContext decoderContext) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (reader.getCurrentBsonType() == BsonType.ARRAY) {
            reader.readStartArray();
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                list.add(this.readValue(reader, decoderContext));
            }
            reader.readEndArray();
        } else {
            list.add(this.readValue(reader, decoderContext));
        }
        return list.toArray();
    }

    @Nullable
    private Object readValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        if (bsonType == BsonType.BINARY && BsonBinarySubType.isUuid(reader.peekBinarySubType()) && reader.peekBinarySize() == 16) {
            return this.mapper.getCodecRegistry().get(UUID.class).decode(reader, decoderContext);
        }
        return this.mapper.getCodecRegistry().get(this.type.getComponentType()).decode(reader, decoderContext);
    }
}

