/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import dev.morphia.mapping.InstanceCreatorFactory;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.NoArgCreator;
import dev.morphia.mapping.codec.MorphiaInstanceCreator;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.experimental.ConstructorCreator;
import dev.morphia.mapping.experimental.UnsafeConstructorCreator;
import dev.morphia.sofia.Sofia;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.function.Supplier;

public class InstanceCreatorFactoryImpl
implements InstanceCreatorFactory {
    private final EntityModel model;
    private Supplier<MorphiaInstanceCreator> creator;

    public InstanceCreatorFactoryImpl(EntityModel model) {
        this.model = model;
    }

    @Override
    public MorphiaInstanceCreator create() {
        if (this.creator == null) {
            if (!this.model.getType().isInterface()) {
                try {
                    Constructor<?> constructor = this.model.getType().getDeclaredConstructor(new Class[0]);
                    this.creator = () -> new NoArgCreator(constructor);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Constructor<?> constructor = ConstructorCreator.getFullConstructor(this.model);
                        this.creator = () -> new ConstructorCreator(this.model, constructor);
                    }
                    catch (MappingException e1) {
                        UnsafeConstructorCreator unsafeConstructorCreator = new UnsafeConstructorCreator(this.model);
                        this.creator = () -> unsafeConstructorCreator;
                    }
                }
            } else {
                throw new MappingException(Sofia.noSuitableConstructor(this.model.getType().getName(), new Locale[0]));
            }
        }
        return this.creator.get();
    }
}

