/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.stages;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.stages.Stage;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonWriter;

public class Sort
extends Stage {
    private final List<SortType> sorts = new ArrayList<SortType>();

    protected Sort() {
        super("$sort");
    }

    @Deprecated(forRemoval=true)
    public static Sort on() {
        return new Sort();
    }

    public static Sort sort() {
        return new Sort();
    }

    public Sort ascending(String field, String ... additional) {
        this.sorts.add(new SortType(field, Direction.ASCENDING));
        for (String another : additional) {
            this.sorts.add(new SortType(another, Direction.ASCENDING));
        }
        return this;
    }

    public Sort descending(String field, String ... additional) {
        this.sorts.add(new SortType(field, Direction.DESCENDING));
        for (String another : additional) {
            this.sorts.add(new SortType(another, Direction.DESCENDING));
        }
        return this;
    }

    public List<SortType> getSorts() {
        return this.sorts;
    }

    public Sort meta(String field) {
        this.sorts.add(new SortType(field, Direction.META));
        return this;
    }

    public class SortType {
        private final String field;
        private final Direction direction;

        protected SortType(String field, Direction direction) {
            this.field = field;
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String getField() {
            return this.field;
        }
    }

    public static enum Direction {
        ASCENDING{

            @Override
            public void encode(BsonWriter writer) {
                writer.writeInt32(1);
            }
        }
        ,
        DESCENDING{

            @Override
            public void encode(BsonWriter writer) {
                writer.writeInt32(-1);
            }
        }
        ,
        META{

            @Override
            public void encode(BsonWriter writer) {
                ExpressionHelper.document(writer, () -> writer.writeString("$meta", "textScore"));
            }
        };


        public abstract void encode(BsonWriter var1);
    }
}

