/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.stages;

import com.mongodb.client.model.MergeOptions;
import com.mongodb.lang.Nullable;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.aggregation.experimental.stages.Stage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Merge<M>
extends Stage {
    private Class<M> type;
    private String database;
    private String collection;
    private List<String> on;
    private Map<String, Expression> variables;
    private MergeOptions.WhenMatched whenMatched;
    private List<Stage> whenMatchedPipeline;
    private MergeOptions.WhenNotMatched whenNotMatched;

    protected Merge(Class<M> type2) {
        this();
        this.type = type2;
    }

    protected Merge() {
        super("$merge");
    }

    protected Merge(String collection) {
        this();
        this.collection = collection;
    }

    protected Merge(String database, String collection) {
        this();
        this.database = database;
        this.collection = collection;
    }

    public static <M> Merge<M> into(Class<M> type2) {
        return new Merge<M>(type2);
    }

    public static Merge<?> into(String collection) {
        return new Merge(collection);
    }

    public static Merge<?> into(String database, String collection) {
        return new Merge(database, collection);
    }

    public String getCollection() {
        return this.collection;
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    public List<String> getOn() {
        return this.on;
    }

    @Nullable
    public Class<M> getType() {
        return this.type;
    }

    public Map<String, Expression> getVariables() {
        return this.variables;
    }

    public MergeOptions.WhenMatched getWhenMatched() {
        return this.whenMatched;
    }

    public List<Stage> getWhenMatchedPipeline() {
        return this.whenMatchedPipeline;
    }

    public MergeOptions.WhenNotMatched getWhenNotMatched() {
        return this.whenNotMatched;
    }

    public Merge<M> let(String variable, Expression value) {
        if (this.variables == null) {
            this.variables = new LinkedHashMap<String, Expression>();
        }
        this.variables.put(variable, value);
        return this;
    }

    public Merge<M> on(String field, String ... fields) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(field);
        list.addAll(Arrays.asList(fields));
        this.on = list;
        return this;
    }

    public Merge<M> whenMatched(MergeOptions.WhenMatched whenMatched) {
        this.whenMatched = whenMatched;
        return this;
    }

    public Merge<M> whenMatched(List<Stage> pipeline) {
        this.whenMatchedPipeline = pipeline;
        return this;
    }

    public Merge<M> whenNotMatched(MergeOptions.WhenNotMatched whenNotMatched) {
        this.whenNotMatched = whenNotMatched;
        return this;
    }
}

