/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.expressions.impls;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.mapping.Mapper;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class MathExpression
extends Expression {
    private final List<Expression> operands;

    public MathExpression(String operation, List<Expression> operands) {
        super(operation);
        this.operands = operands;
    }

    public MathExpression(String operation, Expression operand) {
        super(operation);
        this.operands = Arrays.asList(operand);
    }

    @Override
    public void encode(Mapper mapper, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            writer.writeName(this.getOperation());
            if (this.operands.size() > 1) {
                writer.writeStartArray();
            }
            for (Expression operand : this.operands) {
                if (operand != null) {
                    ExpressionHelper.expression(mapper, writer, operand, encoderContext);
                    continue;
                }
                writer.writeNull();
            }
            if (this.operands.size() > 1) {
                writer.writeEndArray();
            }
        });
    }
}

