/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.expressions.impls;

import com.mongodb.lang.Nullable;
import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.mapping.Mapper;
import java.util.StringJoiner;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class Expression {
    private final String operation;
    private final Object value;

    protected Expression(String operation) {
        this.operation = operation;
        this.value = null;
    }

    public Expression(String operation, @Nullable Object value) {
        this.operation = operation;
        this.value = value;
    }

    public void encode(Mapper mapper, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> ExpressionHelper.value(mapper, writer, this.operation, this.value, encoderContext));
    }

    public String getOperation() {
        return this.operation;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return new StringJoiner(", ", Expression.class.getSimpleName() + "[", "]").add("operation='" + this.operation + "'").toString();
    }
}

