/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.expressions;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.expressions.impls.DateFromParts;
import dev.morphia.aggregation.experimental.expressions.impls.DateFromString;
import dev.morphia.aggregation.experimental.expressions.impls.DateToParts;
import dev.morphia.aggregation.experimental.expressions.impls.DateToString;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.aggregation.experimental.expressions.impls.IsoDates;
import dev.morphia.mapping.Mapper;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public final class DateExpressions {
    private DateExpressions() {
    }

    public static DateFromParts dateFromParts() {
        return new DateFromParts();
    }

    public static DateFromString dateFromString() {
        return new DateFromString();
    }

    public static DateToParts dateToParts(Expression date) {
        return new DateToParts(date);
    }

    public static DateToString dateToString() {
        return new DateToString();
    }

    public static DateExpression dayOfMonth(Expression value) {
        return new DateExpression("$dayOfMonth", value);
    }

    public static DateExpression dayOfWeek(Expression value) {
        return new DateExpression("$dayOfWeek", value);
    }

    public static DateExpression dayOfYear(Expression value) {
        return new DateExpression("$dayOfYear", value);
    }

    public static DateExpression hour(Expression value) {
        return new DateExpression("$hour", value);
    }

    public static IsoDates isoDayOfWeek(Expression value) {
        return new IsoDates("$isoDayOfWeek", value);
    }

    public static IsoDates isoWeek(Expression value) {
        return new IsoDates("$isoWeek", value);
    }

    public static IsoDates isoWeekYear(Expression value) {
        return new IsoDates("$isoWeekYear", value);
    }

    public static DateExpression milliseconds(Expression value) {
        return new DateExpression("$millisecond", value);
    }

    public static DateExpression minute(Expression value) {
        return new DateExpression("$minute", value);
    }

    public static DateExpression month(Expression value) {
        return new DateExpression("$month", value);
    }

    public static DateExpression second(Expression value) {
        return new DateExpression("$second", value);
    }

    public static DateExpression toDate(Expression value) {
        return new DateExpression("$toDate", value);
    }

    public static DateExpression week(Expression value) {
        return new DateExpression("$week", value);
    }

    public static DateExpression year(Expression value) {
        return new DateExpression("$year", value);
    }

    public static class DateExpression
    extends Expression {
        protected DateExpression(String operation, Expression value) {
            super(operation, value);
        }

        @Override
        public void encode(Mapper mapper, BsonWriter writer, EncoderContext encoderContext) {
            ExpressionHelper.document(writer, () -> ExpressionHelper.expression(mapper, writer, this.getOperation(), (Expression)this.getValue(), encoderContext));
        }
    }
}

