/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.expressions;

import dev.morphia.aggregation.experimental.expressions.impls.Accumulator;
import dev.morphia.aggregation.experimental.expressions.impls.AccumulatorExpression;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.aggregation.experimental.expressions.impls.FunctionExpression;
import dev.morphia.aggregation.experimental.expressions.impls.Push;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class AccumulatorExpressions {
    private AccumulatorExpressions() {
    }

    public static AccumulatorExpression accumulator(String initFunction, String accumulateFunction, List<Expression> accumulateArgs, String mergeFunction) {
        return new AccumulatorExpression(initFunction, accumulateFunction, accumulateArgs, mergeFunction);
    }

    public static Expression addToSet(Expression value) {
        return new Expression("$addToSet", value);
    }

    public static Expression avg(Expression value, Expression ... additional) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(value);
        expressions.addAll(Arrays.asList(additional));
        return new Accumulator("$avg", expressions);
    }

    public static Expression first(Expression value) {
        return new Expression("$first", value);
    }

    public static Expression function(String body2, Expression ... args2) {
        return new FunctionExpression(body2, Arrays.asList(args2));
    }

    public static Expression last(Expression value) {
        return new Expression("$last", value);
    }

    public static Expression max(Expression value) {
        return new Expression("$max", value);
    }

    public static Expression min(Expression value) {
        return new Expression("$min", value);
    }

    public static Expression push(Expression value) {
        return new Expression("$push", value);
    }

    public static Push push() {
        return new Push();
    }

    public static Expression stdDevPop(Expression value, Expression ... additional) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(value);
        expressions.addAll(Arrays.asList(additional));
        return new Accumulator("$stdDevPop", expressions);
    }

    public static Expression stdDevSamp(Expression value, Expression ... additional) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(value);
        expressions.addAll(Arrays.asList(additional));
        return new Accumulator("$stdDevSamp", expressions);
    }

    public static Expression sum(Expression first, Expression ... additional) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(first);
        expressions.addAll(Arrays.asList(additional));
        return new Accumulator("$sum", expressions);
    }
}

