/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.codecs.stages;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.codecs.stages.StageCodec;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.aggregation.experimental.stages.Merge;
import dev.morphia.mapping.Mapper;
import java.util.List;
import java.util.Map;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class MergeCodec
extends StageCodec<Merge> {
    public MergeCodec(Mapper mapper) {
        super(mapper);
    }

    @Override
    public Class<Merge> getEncoderClass() {
        return Merge.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, Merge merge, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            Map<String, Expression> variables;
            String collection = merge.getType() != null ? this.getMapper().getEntityModel(merge.getType()).getCollectionName() : merge.getCollection();
            String database = merge.getDatabase();
            if (database == null) {
                writer.writeString("into", collection);
            } else {
                ExpressionHelper.document(writer, "into", () -> {
                    writer.writeString("db", database);
                    writer.writeString("coll", collection);
                });
            }
            List<String> on = merge.getOn();
            if (on != null) {
                if (on.size() == 1) {
                    writer.writeString("on", on.get(0));
                } else {
                    ExpressionHelper.array(writer, "on", () -> on.forEach(writer::writeString));
                }
            }
            if ((variables = merge.getVariables()) != null) {
                ExpressionHelper.document(writer, "let", () -> {
                    for (Map.Entry entry : variables.entrySet()) {
                        ExpressionHelper.value(this.getMapper(), writer, (String)entry.getKey(), entry.getValue(), encoderContext);
                    }
                });
            }
            this.writeEnum(writer, "whenMatched", merge.getWhenMatched());
            ExpressionHelper.value(this.getMapper(), writer, "whenMatched", merge.getWhenMatchedPipeline(), encoderContext);
            this.writeEnum(writer, "whenNotMatched", merge.getWhenNotMatched());
        });
    }

    private void writeEnum(BsonWriter writer, String name, Enum<?> value) {
        if (value != null) {
            writer.writeString(name, value.name().toLowerCase());
        }
    }
}

