/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.codecs.stages;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.codecs.stages.StageCodec;
import dev.morphia.aggregation.experimental.stages.GeoNear;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.experimental.filters.Filter;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class GeoNearCodec
extends StageCodec<GeoNear> {
    public GeoNearCodec(Mapper mapper) {
        super(mapper);
    }

    @Override
    public Class<GeoNear> getEncoderClass() {
        return GeoNear.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, GeoNear value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            ExpressionHelper.value(this.getMapper(), writer, "near", value.getPoint(), encoderContext);
            ExpressionHelper.value(this.getMapper(), writer, "near", value.getCoordinates(), encoderContext);
            ExpressionHelper.value(this.getMapper(), writer, "key", value.getKey(), encoderContext);
            ExpressionHelper.value(this.getMapper(), writer, "distanceField", value.getDistanceField(), encoderContext);
            ExpressionHelper.value(this.getMapper(), writer, "spherical", value.getSpherical(), encoderContext);
            ExpressionHelper.value(this.getMapper(), writer, "maxDistance", value.getMaxDistance(), encoderContext);
            ExpressionHelper.value(this.getMapper(), writer, "minDistance", value.getMinDistance(), encoderContext);
            Filter[] filters = value.getFilters();
            if (filters != null) {
                ExpressionHelper.document(writer, "query", () -> {
                    for (Filter filter : filters) {
                        filter.encode(this.getMapper(), writer, encoderContext);
                    }
                });
            }
            ExpressionHelper.value(this.getMapper(), writer, "distanceMultiplier", value.getDistanceMultiplier(), encoderContext);
            ExpressionHelper.value(this.getMapper(), writer, "includeLocs", value.getIncludeLocs(), encoderContext);
        });
    }
}

