/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import dev.morphia.internal.ReadConfigurable;
import dev.morphia.internal.SessionConfigurable;
import dev.morphia.internal.WriteConfigurable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.Document;

public class AggregationOptions
implements SessionConfigurable<AggregationOptions>,
ReadConfigurable<AggregationOptions>,
WriteConfigurable<AggregationOptions> {
    private boolean allowDiskUse;
    private Integer batchSize;
    private boolean bypassDocumentValidation;
    private Collation collation;
    private Long maxTimeMS;
    private ClientSession clientSession;
    private ReadPreference readPreference;
    private ReadConcern readConcern;
    private WriteConcern writeConcern;
    private Document hint;

    public boolean allowDiskUse() {
        return this.allowDiskUse;
    }

    public AggregationOptions allowDiskUse(boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    public <S, T> AggregateIterable<S> apply(List<Document> documents, MongoCollection<T> collection, Class<S> resultType) {
        MongoCollection<T> bound = collection;
        if (this.readConcern != null) {
            bound = bound.withReadConcern(this.readConcern);
        }
        if (this.readPreference != null) {
            bound = bound.withReadPreference(this.readPreference);
        }
        AggregateIterable<S> aggregate = bound.aggregate(documents, resultType).allowDiskUse(this.allowDiskUse).bypassDocumentValidation(this.bypassDocumentValidation);
        if (this.batchSize != null) {
            aggregate.batchSize(this.batchSize);
        }
        if (this.collation != null) {
            aggregate.collation(this.collation);
        }
        if (this.maxTimeMS != null) {
            aggregate.maxTime(this.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
        if (this.hint != null) {
            aggregate.hint(this.hint);
        }
        return aggregate;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public AggregationOptions batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public boolean bypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public AggregationOptions bypassDocumentValidation(boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public AggregationOptions clientSession(ClientSession clientSession) {
        this.clientSession = clientSession;
        return this;
    }

    @Override
    public ClientSession clientSession() {
        return this.clientSession;
    }

    public Collation collation() {
        return this.collation;
    }

    public AggregationOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public long getMaxTime(TimeUnit unit) {
        return unit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public long getMaxTimeMS() {
        return this.maxTimeMS;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public Document hint() {
        return this.hint;
    }

    public AggregationOptions hint(String hint) {
        this.hint = new Document("hint", hint);
        return this;
    }

    @Override
    public <C> MongoCollection<C> prepare(MongoCollection<C> collection) {
        ReadPreference readPreference;
        ReadConcern readConcern;
        MongoCollection<C> updated = collection;
        WriteConcern writeConcern = this.writeConcern();
        if (writeConcern != null) {
            updated = updated.withWriteConcern(writeConcern);
        }
        if ((readConcern = this.getReadConcern()) != null) {
            updated = updated.withReadConcern(readConcern);
        }
        if ((readPreference = this.getReadPreference()) != null) {
            updated = updated.withReadPreference(readPreference);
        }
        return updated;
    }

    @Override
    public AggregationOptions readConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
        return this;
    }

    @Override
    public AggregationOptions readPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    public long maxTimeMS() {
        return this.maxTimeMS;
    }

    public AggregationOptions maxTimeMS(long maxTimeMS) {
        this.maxTimeMS = maxTimeMS;
        return this;
    }

    public ReadConcern readConcern() {
        return this.readConcern;
    }

    public ReadPreference readPreference() {
        return this.readPreference;
    }

    @Override
    public AggregationOptions writeConcern(@Nullable WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    @Override
    @Nullable
    public WriteConcern writeConcern() {
        return this.writeConcern;
    }
}

