/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental;

import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.aggregation.experimental.Aggregation;
import dev.morphia.aggregation.experimental.AggregationOptions;
import dev.morphia.aggregation.experimental.expressions.Expressions;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.aggregation.experimental.stages.AddFields;
import dev.morphia.aggregation.experimental.stages.AutoBucket;
import dev.morphia.aggregation.experimental.stages.Bucket;
import dev.morphia.aggregation.experimental.stages.CollectionStats;
import dev.morphia.aggregation.experimental.stages.Count;
import dev.morphia.aggregation.experimental.stages.CurrentOp;
import dev.morphia.aggregation.experimental.stages.Facet;
import dev.morphia.aggregation.experimental.stages.GeoNear;
import dev.morphia.aggregation.experimental.stages.GraphLookup;
import dev.morphia.aggregation.experimental.stages.Group;
import dev.morphia.aggregation.experimental.stages.IndexStats;
import dev.morphia.aggregation.experimental.stages.Limit;
import dev.morphia.aggregation.experimental.stages.Lookup;
import dev.morphia.aggregation.experimental.stages.Match;
import dev.morphia.aggregation.experimental.stages.Merge;
import dev.morphia.aggregation.experimental.stages.Out;
import dev.morphia.aggregation.experimental.stages.PlanCacheStats;
import dev.morphia.aggregation.experimental.stages.Projection;
import dev.morphia.aggregation.experimental.stages.Redact;
import dev.morphia.aggregation.experimental.stages.ReplaceRoot;
import dev.morphia.aggregation.experimental.stages.ReplaceWith;
import dev.morphia.aggregation.experimental.stages.Sample;
import dev.morphia.aggregation.experimental.stages.Skip;
import dev.morphia.aggregation.experimental.stages.Sort;
import dev.morphia.aggregation.experimental.stages.SortByCount;
import dev.morphia.aggregation.experimental.stages.Stage;
import dev.morphia.aggregation.experimental.stages.UnionWith;
import dev.morphia.aggregation.experimental.stages.Unset;
import dev.morphia.aggregation.experimental.stages.Unwind;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.reader.DocumentReader;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.internal.MorphiaCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class AggregationImpl<T>
implements Aggregation<T> {
    private final Datastore datastore;
    private final Class<?> source;
    private final MongoCollection<T> collection;
    private final List<Stage> stages = new ArrayList<Stage>();

    public AggregationImpl(Datastore datastore, MongoCollection<T> collection) {
        this.datastore = datastore;
        this.collection = collection;
        this.source = null;
    }

    public AggregationImpl(Datastore datastore, Class<T> source, MongoCollection<T> collection) {
        this.datastore = datastore;
        this.source = source;
        this.collection = collection;
    }

    @Override
    public Aggregation<T> addFields(AddFields fields) {
        this.addStage(fields);
        return this;
    }

    @Override
    public Aggregation<T> autoBucket(AutoBucket bucket) {
        this.addStage(bucket);
        return this;
    }

    @Override
    public Aggregation<T> bucket(Bucket bucket) {
        this.addStage(bucket);
        return this;
    }

    @Override
    public Aggregation<T> collStats(CollectionStats stats) {
        this.addStage(stats);
        return this;
    }

    @Override
    public Aggregation<T> count(String name) {
        this.addStage(new Count(name));
        return this;
    }

    @Override
    public Aggregation<T> currentOp(CurrentOp currentOp) {
        this.addStage(currentOp);
        return this;
    }

    @Override
    public Aggregation<T> facet(Facet facet) {
        this.addStage(facet);
        return this;
    }

    @Override
    public <R> MorphiaCursor<R> execute(Class<R> resultType) {
        MappingCursor<R> cursor;
        if (this.datastore.getMapper().isMappable(resultType) && !resultType.equals(this.collection.getDocumentClass())) {
            MongoCollection<Document> collection = this.collection.withDocumentClass(Document.class);
            Iterator results = collection.aggregate(this.getDocuments()).iterator();
            EntityModel entityModel = this.datastore.getMapper().getEntityModel(this.collection.getDocumentClass());
            cursor = new MappingCursor<R>((MongoCursor<Document>)results, this.datastore.getMapper().getCodecRegistry().get(resultType), entityModel.getDiscriminatorKey());
        } else {
            cursor = this.collection.aggregate(this.getDocuments(), resultType).iterator();
        }
        return new MorphiaCursor(cursor);
    }

    @Override
    public <R> MorphiaCursor<R> execute(Class<R> resultType, AggregationOptions options) {
        return new MorphiaCursor(options.apply(this.getDocuments(), this.collection, resultType).iterator());
    }

    @Override
    public Aggregation<T> geoNear(GeoNear near) {
        this.addStage(near);
        return this;
    }

    @Override
    public Aggregation<T> graphLookup(GraphLookup lookup) {
        this.addStage(lookup);
        return this;
    }

    @Override
    public Aggregation<T> group(Group group) {
        this.addStage(group);
        return this;
    }

    @Override
    public Aggregation<T> indexStats() {
        this.addStage(IndexStats.indexStats());
        return this;
    }

    @Override
    public Aggregation<T> limit(long limit) {
        this.addStage(Limit.limit(limit));
        return this;
    }

    @Override
    public Aggregation<T> lookup(Lookup lookup) {
        this.addStage(lookup);
        return this;
    }

    @Override
    public Aggregation<T> match(Filter ... filters) {
        if (this.stages.isEmpty()) {
            Arrays.stream(filters).filter(f -> f.getName().equals("$eq")).forEach(f -> f.entityType(this.source));
        }
        this.addStage(Match.match(filters));
        return this;
    }

    @Override
    public <M> void merge(Merge<M> merge) {
        this.addStage(merge);
        this.collection.aggregate(this.getDocuments()).toCollection();
    }

    @Override
    public <M> void merge(Merge<M> merge, AggregationOptions options) {
        this.addStage(merge);
        Class<M> type2 = merge.getType();
        type2 = type2 != null ? type2 : Document.class;
        options.apply(this.getDocuments(), this.collection, type2).toCollection();
    }

    @Override
    public <O> void out(Out<O> out) {
        this.addStage(out);
        this.collection.aggregate(this.getDocuments()).toCollection();
    }

    @Override
    public <O> void out(Out<O> out, AggregationOptions options) {
        this.addStage(out);
        Class<?> type2 = out.getType();
        type2 = type2 != null ? type2 : Document.class;
        options.apply(this.getDocuments(), this.collection, type2).toCollection();
    }

    @Override
    public Aggregation<T> planCacheStats() {
        this.addStage(PlanCacheStats.planCacheStats());
        return this;
    }

    @Override
    public Aggregation<T> project(Projection projection) {
        this.addStage(projection);
        return this;
    }

    @Override
    public Aggregation<T> redact(Redact redact) {
        this.addStage(redact);
        return this;
    }

    @Override
    public Aggregation<T> replaceRoot(ReplaceRoot root) {
        this.addStage(root);
        return this;
    }

    @Override
    public Aggregation<T> replaceWith(ReplaceWith with) {
        this.addStage(with);
        return this;
    }

    @Override
    public Aggregation<T> sample(long sample) {
        this.addStage(Sample.sample(sample));
        return this;
    }

    @Override
    public Aggregation<T> skip(long skip) {
        this.addStage(Skip.skip(skip));
        return this;
    }

    @Override
    public Aggregation<T> sort(Sort sort2) {
        this.addStage(sort2);
        return this;
    }

    @Override
    public Aggregation<T> sortByCount(Expression sort2) {
        this.addStage(SortByCount.sortByCount(sort2));
        return this;
    }

    @Override
    public Aggregation<T> unionWith(Class<?> type2, Stage first, Stage ... others) {
        this.addStage(new UnionWith(type2, Expressions.toList(first, others)));
        return this;
    }

    @Override
    public Aggregation<T> unionWith(String collection, Stage first, Stage ... others) {
        this.addStage(new UnionWith(collection, Expressions.toList(first, others)));
        return this;
    }

    @Override
    public Aggregation<T> unset(Unset unset) {
        this.addStage(unset);
        return this;
    }

    @Override
    public Aggregation<T> unwind(Unwind unwind) {
        this.addStage(unwind);
        return this;
    }

    private void addStage(Stage stage) {
        stage.aggregation(this);
        this.stages.add(stage);
    }

    private List<Document> getDocuments() {
        return this.stages.stream().map(s2 -> {
            Codec<?> codec = this.datastore.getMapper().getCodecRegistry().get(s2.getClass());
            DocumentWriter writer = new DocumentWriter(this.datastore.getMapper());
            codec.encode(writer, s2, EncoderContext.builder().build());
            return writer.getDocument();
        }).collect(Collectors.toList());
    }

    private static class MappingCursor<R>
    implements MongoCursor<R> {
        private final MongoCursor<Document> results;
        private final Codec<R> codec;
        private final String discriminator;

        MappingCursor(MongoCursor<Document> results, Codec<R> codec, String discriminator) {
            this.results = results;
            this.codec = codec;
            this.discriminator = discriminator;
        }

        @Override
        public void close() {
            this.results.close();
        }

        @Override
        public boolean hasNext() {
            return this.results.hasNext();
        }

        @Override
        public R next() {
            return this.map(this.results.next());
        }

        @Override
        @Nullable
        public R tryNext() {
            return this.hasNext() ? (R)this.next() : null;
        }

        @Override
        @Nullable
        public ServerCursor getServerCursor() {
            return this.results.getServerCursor();
        }

        @Override
        public ServerAddress getServerAddress() {
            return this.results.getServerAddress();
        }

        private R map(Document next2) {
            next2.remove(this.discriminator);
            return (R)this.codec.decode(new DocumentReader(next2), DecoderContext.builder().build());
        }
    }
}

