/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation;

import com.mongodb.AggregationOptions;
import com.mongodb.ReadPreference;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UnwindOptions;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.aggregation.Accumulator;
import dev.morphia.aggregation.AggregationPipeline;
import dev.morphia.aggregation.GeoNear;
import dev.morphia.aggregation.Group;
import dev.morphia.aggregation.Projection;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.query.BucketAutoOptions;
import dev.morphia.query.BucketOptions;
import dev.morphia.query.Query;
import dev.morphia.query.Sort;
import dev.morphia.sofia.Sofia;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="2.0", forRemoval=true)
public class AggregationPipelineImpl
implements AggregationPipeline {
    private static final Logger LOG = LoggerFactory.getLogger(AggregationPipelineImpl.class);
    private final MongoCollection collection;
    private final Class source;
    private final List<Document> stages = new ArrayList<Document>();
    private final Mapper mapper;
    private boolean firstStage;

    public AggregationPipelineImpl(Datastore datastore, MongoCollection collection, Class source) {
        this.collection = collection;
        this.mapper = datastore.getMapper();
        this.source = source;
    }

    @Override
    public <U> Iterator<U> aggregate(Class<U> target) {
        return this.aggregate(target, AggregationOptions.builder().build(), this.collection.getReadPreference());
    }

    @Override
    public <U> Iterator<U> aggregate(Class<U> target, AggregationOptions options) {
        return this.aggregate(target, options, this.collection.getReadPreference());
    }

    @Override
    public <U> Iterator<U> aggregate(Class<U> target, AggregationOptions options, ReadPreference readPreference) {
        return this.aggregate(this.mapper.getCollection(target).getNamespace().getCollectionName(), target, options, readPreference);
    }

    @Override
    public <U> Iterator<U> aggregate(String collectionName, Class<U> target, AggregationOptions options, ReadPreference readPreference) {
        LOG.debug("stages = " + this.stages);
        AggregateIterable<U> cursor = this.collection.aggregate(this.stages, target);
        return cursor.iterator();
    }

    @Override
    public AggregationPipeline bucket(String field, List<?> boundaries) {
        return this.bucket(field, boundaries, new BucketOptions());
    }

    @Override
    public AggregationPipeline bucket(String field, List<?> boundaries, BucketOptions options) {
        if (boundaries.size() < 2) {
            throw new RuntimeException("Boundaries list should be present and has at least 2 elements");
        }
        Document document = options.toDocument();
        document.put("groupBy", (Object)("$" + field));
        document.put("boundaries", (Object)boundaries);
        this.stages.add(new Document("$bucket", document));
        return this;
    }

    @Override
    public AggregationPipeline bucketAuto(String field, int bucketCount) {
        return this.bucketAuto(field, bucketCount, new BucketAutoOptions());
    }

    @Override
    public AggregationPipeline bucketAuto(String field, int bucketCount, BucketAutoOptions options) {
        if (bucketCount < 1) {
            throw new RuntimeException("bucket count should be more than 0");
        }
        Document document = options.toDocument();
        document.put("groupBy", (Object)("$" + field));
        document.put("buckets", (Object)bucketCount);
        this.stages.add(new Document("$bucketAuto", document));
        return this;
    }

    @Override
    public AggregationPipeline geoNear(GeoNear geoNear) {
        throw new UnsupportedOperationException(Sofia.legacyOperation(new Locale[0]));
    }

    @Override
    public AggregationPipeline group(Group ... groupings) {
        return this.group((String)null, groupings);
    }

    @Override
    public AggregationPipeline group(@Nullable String id, Group ... groupings) {
        Document group = new Document();
        group.put("_id", (Object)(id != null ? "$" + id : null));
        for (Group grouping : groupings) {
            group.putAll(this.toDocument(grouping));
        }
        this.stages.add(new Document("$group", group));
        return this;
    }

    @Override
    public AggregationPipeline group(List<Group> id, Group ... groupings) {
        Document idGroup = new Document();
        for (Group group : id) {
            idGroup.putAll(this.toDocument(group));
        }
        Document group = new Document("_id", idGroup);
        for (Group grouping : groupings) {
            group.putAll(this.toDocument(grouping));
        }
        this.stages.add(new Document("$group", group));
        return this;
    }

    @Override
    public AggregationPipeline limit(int count) {
        this.stages.add(new Document("$limit", count));
        return this;
    }

    @Override
    public AggregationPipeline lookup(String from, String localField, String foreignField, String as) {
        this.stages.add(new Document("$lookup", new Document("from", from).append("localField", localField).append("foreignField", foreignField).append("as", as)));
        return this;
    }

    @Override
    public AggregationPipeline match(Query query) {
        this.stages.add(new Document("$match", query.disableValidation().toDocument()));
        return this;
    }

    @Override
    public <U> Iterator<U> out(Class<U> target) {
        return this.out(this.mapper.getCollection(target).getNamespace().getCollectionName(), target);
    }

    @Override
    public <U> Iterator<U> out(Class<U> target, AggregationOptions options) {
        return this.out(this.mapper.getCollection(target).getNamespace().getCollectionName(), target, options);
    }

    @Override
    public <U> Iterator<U> out(String collectionName, Class<U> target) {
        return this.out(collectionName, target, AggregationOptions.builder().build());
    }

    @Override
    public <U> Iterator<U> out(String collectionName, Class<U> target, AggregationOptions options) {
        this.stages.add(new Document("$out", collectionName));
        return this.aggregate(target, options);
    }

    @Override
    public AggregationPipeline project(Projection ... projections) {
        this.firstStage = this.stages.isEmpty();
        Document document = new Document();
        for (Projection projection : projections) {
            document.putAll(this.toDocument(projection));
        }
        this.stages.add(new Document("$project", document));
        return this;
    }

    @Override
    public AggregationPipeline sample(int sampleSize) {
        this.stages.add(new Document("$sample", new Document("size", sampleSize)));
        return this;
    }

    @Override
    public AggregationPipeline skip(int count) {
        this.stages.add(new Document("$skip", count));
        return this;
    }

    @Override
    public AggregationPipeline sort(Sort ... sorts) {
        Document sortList = new Document();
        for (Sort sort2 : sorts) {
            sortList.put(sort2.getField(), (Object)sort2.getOrder());
        }
        this.stages.add(new Document("$sort", sortList));
        return this;
    }

    @Override
    public AggregationPipeline sortByCount(String field) {
        this.stages.add(new Document("$sortByCount", "$" + field));
        return this;
    }

    @Override
    public AggregationPipeline unwind(String field, UnwindOptions options) {
        Document unwindOptions = new Document("path", "$" + field).append("preserveNullAndEmptyArrays", options.isPreserveNullAndEmptyArrays());
        String includeArrayIndex = options.getIncludeArrayIndex();
        if (includeArrayIndex != null) {
            unwindOptions.append("includeArrayIndex", includeArrayIndex);
        }
        this.stages.add(new Document("$unwind", unwindOptions));
        return this;
    }

    @Override
    public AggregationPipeline unwind(String field) {
        this.stages.add(new Document("$unwind", "$" + field));
        return this;
    }

    public List<Document> getStages() {
        return this.stages;
    }

    public String toString() {
        return this.stages.toString();
    }

    private void putIfNull(Document document, String name, @Nullable Object value) {
        if (value != null) {
            document.put(name, value);
        }
    }

    private Document toDocument(Group group) {
        Document document = new Document();
        Accumulator accumulator = group.getAccumulator();
        if (accumulator != null) {
            document.put(group.getName(), (Object)accumulator.toDocument());
        } else {
            List<Projection> projections = group.getProjections();
            if (projections != null) {
                Document projection = new Document();
                for (Projection p : projections) {
                    projection.putAll(this.toDocument(p));
                }
                document.put(group.getName(), (Object)projection);
            } else {
                Group nested = group.getNested();
                if (nested != null) {
                    document.put(group.getName(), (Object)this.toDocument(nested));
                } else {
                    document.put(group.getName(), (Object)group.getSourceField());
                }
            }
        }
        return document;
    }

    private Document toDocument(Projection projection) {
        List<Projection> list;
        String target = projection.getTarget();
        if (this.firstStage) {
            EntityModel entityModel = this.mapper.getEntityModel(this.source);
            PropertyModel property = entityModel != null && target != null ? entityModel.getProperty(target) : null;
            String string = target = property != null ? property.getMappedName() : target;
        }
        if ((list = projection.getProjections()) != null) {
            Document projections = new Document();
            for (Projection subProjection : list) {
                projections.putAll(this.toDocument(subProjection));
            }
            return new Document(target, projections);
        }
        if (projection.getSource() != null) {
            return new Document(target, projection.getSource());
        }
        if (projection.getArguments() != null) {
            List<Object> args2 = this.toExpressionArgs(projection.getArguments());
            if (target == null) {
                Object firstArg;
                if (args2.size() == 1 && (firstArg = args2.get(0)) instanceof Document) {
                    return (Document)firstArg;
                }
                throw new UnsupportedOperationException("aggregation support pending");
            }
            if (args2.size() == 1) {
                return new Document(target, args2.get(0));
            }
            return new Document(target, args2);
        }
        return new Document(target, projection.isSuppressed() ? 0 : 1);
    }

    private List<Object> toExpressionArgs(@Nullable List<Object> args2) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (args2 != null) {
            for (Object arg : args2) {
                if (arg instanceof Projection) {
                    Projection projection = (Projection)arg;
                    if (projection.getArguments() != null || projection.getProjections() != null || projection.getSource() != null) {
                        result.add(this.toDocument(projection));
                        continue;
                    }
                    result.add("$" + projection.getTarget());
                    continue;
                }
                result.add(arg);
            }
        }
        return result;
    }
}

