/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation;

import dev.morphia.aggregation.AggregationElement;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

public class Accumulator
implements AggregationElement {
    private final String operation;
    private final Object value;

    public Accumulator(String operation, String field) {
        this(operation, (Object)("$" + field));
    }

    public Accumulator(String operation, Object field) {
        this.operation = operation;
        this.value = field;
    }

    public static Accumulator accumulator(String operation, String field) {
        return new Accumulator(operation, field);
    }

    public static Accumulator accumulator(String operation, Object field) {
        return new Accumulator(operation, field);
    }

    public String getOperation() {
        return this.operation;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Document toDocument() {
        Document document = new Document();
        if (this.value instanceof List) {
            ArrayList<Document> dbValue = new ArrayList<Document>();
            for (Object o : (List)this.value) {
                if (o instanceof AggregationElement) {
                    dbValue.add(((AggregationElement)o).toDocument());
                    continue;
                }
                dbValue.add((Document)o);
            }
            document.put(this.operation, (Object)dbValue);
        } else if (this.value instanceof AggregationElement) {
            document.put(this.operation, (Object)((AggregationElement)this.value).toDocument());
        } else {
            document.put(this.operation, this.value);
        }
        return document;
    }
}

