/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import com.mchange.v1.util.StringTokenizerUtils;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.FallbackMLog;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogClasses;
import com.mchange.v2.log.MLogConfig;
import com.mchange.v2.log.MLogInitializationException;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.log.NameTransformer;
import java.util.ArrayList;

public abstract class MLog {
    private static NameTransformer _transformer;
    private static MLog _mlog;
    private static MLogger _logger;

    private static synchronized NameTransformer transformer() {
        return _transformer;
    }

    private static synchronized MLog mlog() {
        return _mlog;
    }

    private static synchronized MLogger logger() {
        return _logger;
    }

    public static synchronized void refreshConfig(MultiPropertiesConfig[] multiPropertiesConfigArray, String string) {
        MLogConfig.refresh(multiPropertiesConfigArray, string);
        String string2 = MLogConfig.getProperty("com.mchange.v2.log.MLog");
        String[] stringArray = null;
        if (string2 == null) {
            string2 = MLogConfig.getProperty("com.mchange.v2.log.mlog");
        }
        if (string2 != null) {
            stringArray = StringTokenizerUtils.tokenizeToArray(string2, ", \t\r\n");
        }
        boolean bl = false;
        MLog mLog = null;
        if (stringArray != null) {
            mLog = MLog.findByClassnames(stringArray, true);
        }
        if (mLog == null) {
            mLog = MLog.findByClassnames(MLogClasses.SEARCH_CLASSNAMES, false);
        }
        if (mLog == null) {
            bl = true;
            mLog = new FallbackMLog();
        }
        _mlog = mLog;
        if (bl) {
            MLog.info("Using " + _mlog.getClass().getName() + " -- Named logger's not supported, everything goes to System.err.");
        }
        NameTransformer nameTransformer = null;
        String string3 = MLogConfig.getProperty("com.mchange.v2.log.NameTransformer");
        if (string3 == null) {
            string3 = MLogConfig.getProperty("com.mchange.v2.log.nametransformer");
        }
        try {
            if (string3 != null) {
                nameTransformer = (NameTransformer)Class.forName(string3).newInstance();
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to instantiate com.mchange.v2.log.NameTransformer '" + string3 + "'!");
            exception.printStackTrace();
        }
        _transformer = nameTransformer;
        _logger = MLog.getLogger(MLog.class);
        Thread thread2 = new Thread("MLog-Init-Reporter"){
            final MLogger logo = MLog.access$000();
            String loggerDesc = MLog.access$100().getClass().getName();

            @Override
            public void run() {
                if ("com.mchange.v2.log.jdk14logging.Jdk14MLog".equals(this.loggerDesc)) {
                    this.loggerDesc = "java 1.4+ standard";
                } else if ("com.mchange.v2.log.log4j2.Log4j2MLog".equals(this.loggerDesc)) {
                    this.loggerDesc = "log4j2";
                } else if ("com.mchange.v2.log.log4j.Log4jMLog".equals(this.loggerDesc)) {
                    this.loggerDesc = "log4j";
                } else if ("com.mchange.v2.log.slf4j.Slf4jMLog".equals(this.loggerDesc)) {
                    this.loggerDesc = "slf4j";
                }
                if (this.logo.isLoggable(MLevel.INFO)) {
                    this.logo.log(MLevel.INFO, "MLog clients using " + this.loggerDesc + " logging.");
                }
                MLogConfig.logDelayedItems(this.logo);
                if (this.logo.isLoggable(MLevel.FINEST)) {
                    this.logo.log(MLevel.FINEST, "Config available to MLog library: " + MLogConfig.dump());
                }
            }
        };
        thread2.start();
    }

    public static MLog findByClassnames(String[] stringArray, boolean bl) {
        int n;
        ArrayList<String> arrayList = null;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            try {
                return (MLog)Class.forName(MLogClasses.resolveIfAlias(stringArray[n])).newInstance();
            }
            catch (Exception exception) {
                if (exception instanceof MLogInitializationException) {
                    System.err.println("MLog initialization issue: " + exception.getMessage());
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(stringArray[n]);
                if (!bl) continue;
                System.err.println("com.mchange.v2.log.MLog '" + stringArray[n] + "' could not be loaded!");
                exception.printStackTrace();
                continue;
            }
        }
        System.err.println("Tried without success to load the following MLog classes:");
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            System.err.println("\t" + arrayList.get(n));
        }
        return null;
    }

    public static MLog instance() {
        return MLog.mlog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLogger getLogger(String string) {
        NameTransformer nameTransformer = null;
        MLog mLog = null;
        Object object = MLog.class;
        synchronized (MLog.class) {
            String string2;
            nameTransformer = MLog.transformer();
            mLog = MLog.instance();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            object = nameTransformer == null ? MLog.instance().getMLogger(string) : ((string2 = nameTransformer.transformName(string)) != null ? mLog.getMLogger(string2) : mLog.getMLogger(string));
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLogger getLogger(Class clazz) {
        NameTransformer nameTransformer = null;
        MLog mLog = null;
        Object object = MLog.class;
        synchronized (MLog.class) {
            String string;
            nameTransformer = MLog.transformer();
            mLog = MLog.instance();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            object = nameTransformer == null ? mLog.getMLogger(clazz) : ((string = nameTransformer.transformName(clazz)) != null ? mLog.getMLogger(string) : mLog.getMLogger(clazz));
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLogger getLogger() {
        NameTransformer nameTransformer = null;
        MLog mLog = null;
        Object object = MLog.class;
        synchronized (MLog.class) {
            String string;
            nameTransformer = MLog.transformer();
            mLog = MLog.instance();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            object = nameTransformer == null ? mLog.getMLogger() : ((string = nameTransformer.transformName()) != null ? mLog.getMLogger(string) : mLog.getMLogger());
            return object;
        }
    }

    public static void log(MLevel mLevel, String string) {
        MLog.instance();
        MLog.getLogger().log(mLevel, string);
    }

    public static void log(MLevel mLevel, String string, Object object) {
        MLog.instance();
        MLog.getLogger().log(mLevel, string, object);
    }

    public static void log(MLevel mLevel, String string, Object[] objectArray) {
        MLog.instance();
        MLog.getLogger().log(mLevel, string, objectArray);
    }

    public static void log(MLevel mLevel, String string, Throwable throwable) {
        MLog.instance();
        MLog.getLogger().log(mLevel, string, throwable);
    }

    public static void logp(MLevel mLevel, String string, String string2, String string3) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3);
    }

    public static void logp(MLevel mLevel, String string, String string2, String string3, Object object) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3, object);
    }

    public static void logp(MLevel mLevel, String string, String string2, String string3, Object[] objectArray) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3, objectArray);
    }

    public static void logp(MLevel mLevel, String string, String string2, String string3, Throwable throwable) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3, throwable);
    }

    public static void logrb(MLevel mLevel, String string, String string2, String string3, String string4) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3, string4);
    }

    public static void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Object object) {
        MLog.instance();
        MLog.getLogger().logrb(mLevel, string, string2, string3, string4, object);
    }

    public static void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Object[] objectArray) {
        MLog.instance();
        MLog.getLogger().logrb(mLevel, string, string2, string3, string4, objectArray);
    }

    public static void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Throwable throwable) {
        MLog.instance();
        MLog.getLogger().logrb(mLevel, string, string2, string3, string4, throwable);
    }

    public static void entering(String string, String string2) {
        MLog.instance();
        MLog.getLogger().entering(string, string2);
    }

    public static void entering(String string, String string2, Object object) {
        MLog.instance();
        MLog.getLogger().entering(string, string2, object);
    }

    public static void entering(String string, String string2, Object[] objectArray) {
        MLog.instance();
        MLog.getLogger().entering(string, string2, objectArray);
    }

    public static void exiting(String string, String string2) {
        MLog.instance();
        MLog.getLogger().exiting(string, string2);
    }

    public static void exiting(String string, String string2, Object object) {
        MLog.instance();
        MLog.getLogger().exiting(string, string2, object);
    }

    public static void throwing(String string, String string2, Throwable throwable) {
        MLog.instance();
        MLog.getLogger().throwing(string, string2, throwable);
    }

    public static void severe(String string) {
        MLog.instance();
        MLog.getLogger().severe(string);
    }

    public static void warning(String string) {
        MLog.instance();
        MLog.getLogger().warning(string);
    }

    public static void info(String string) {
        MLog.instance();
        MLog.getLogger().info(string);
    }

    public static void config(String string) {
        MLog.instance();
        MLog.getLogger().config(string);
    }

    public static void fine(String string) {
        MLog.instance();
        MLog.getLogger().fine(string);
    }

    public static void finer(String string) {
        MLog.instance();
        MLog.getLogger().finer(string);
    }

    public static void finest(String string) {
        MLog.instance();
        MLog.getLogger().finest(string);
    }

    public MLogger getMLogger(Class clazz) {
        return this.getMLogger(clazz.getName());
    }

    public abstract MLogger getMLogger(String var1);

    public abstract MLogger getMLogger();

    static /* synthetic */ MLogger access$000() {
        return _logger;
    }

    static /* synthetic */ MLog access$100() {
        return _mlog;
    }

    static {
        MLog.refreshConfig(null, null);
    }
}

