/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferBackedInputStream
extends InputStream {
    protected final ByteBuffer _b;

    public ByteBufferBackedInputStream(ByteBuffer buf) {
        this._b = buf;
    }

    @Override
    public int available() {
        return this._b.remaining();
    }

    @Override
    public int read() throws IOException {
        return this._b.hasRemaining() ? this._b.get() & 0xFF : -1;
    }

    @Override
    public int read(byte[] bytes, int off, int len2) throws IOException {
        if (!this._b.hasRemaining()) {
            return -1;
        }
        len2 = Math.min(len2, this._b.remaining());
        this._b.get(bytes, off, len2);
        return len2;
    }
}

