/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.util.cipher;

import android.util.Base64;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AESCrypt {
    private static final String TAG = "AESCrypt";
    private static final String AES_MODE = "AES/CBC/PKCS7Padding";
    private static final String CHARSET = "UTF-8";
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final byte[] ivBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static boolean DEBUG_LOG_ENABLED = false;

    private static SecretKeySpec generateKey(String string2) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
        byte[] byArray = string2.getBytes(CHARSET);
        messageDigest.update(byArray, 0, byArray.length);
        byte[] byArray2 = messageDigest.digest();
        AESCrypt.log("SHA-256 key ", byArray2);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "AES");
        return secretKeySpec;
    }

    public static String encrypt(String string2, String string3) throws GeneralSecurityException {
        try {
            SecretKeySpec secretKeySpec = AESCrypt.generateKey(string2);
            AESCrypt.log("message", string3);
            byte[] byArray = AESCrypt.encrypt(secretKeySpec, ivBytes, string3.getBytes(CHARSET));
            String string4 = Base64.encodeToString((byte[])byArray, (int)2);
            AESCrypt.log("Base64.NO_WRAP", string4);
            return string4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (DEBUG_LOG_ENABLED) {
                Log.e((String)TAG, (String)"UnsupportedEncodingException ", (Throwable)unsupportedEncodingException);
            }
            throw new GeneralSecurityException(unsupportedEncodingException);
        }
    }

    public static byte[] encrypt(SecretKeySpec secretKeySpec, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        byte[] byArray3 = cipher.doFinal(byArray2);
        AESCrypt.log("cipherText", byArray3);
        return byArray3;
    }

    public static String decrypt(String string2, String string3) throws GeneralSecurityException {
        try {
            SecretKeySpec secretKeySpec = AESCrypt.generateKey(string2);
            AESCrypt.log("base64EncodedCipherText", string3);
            byte[] byArray = Base64.decode((String)string3, (int)2);
            AESCrypt.log("decodedCipherText", byArray);
            byte[] byArray2 = AESCrypt.decrypt(secretKeySpec, ivBytes, byArray);
            AESCrypt.log("decryptedBytes", byArray2);
            String string4 = new String(byArray2, CHARSET);
            AESCrypt.log("message", string4);
            return string4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (DEBUG_LOG_ENABLED) {
                Log.e((String)TAG, (String)"UnsupportedEncodingException ", (Throwable)unsupportedEncodingException);
            }
            throw new GeneralSecurityException(unsupportedEncodingException);
        }
    }

    public static byte[] decrypt(SecretKeySpec secretKeySpec, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        byte[] byArray3 = cipher.doFinal(byArray2);
        AESCrypt.log("decryptedBytes", byArray3);
        return byArray3;
    }

    private static void log(String string2, byte[] byArray) {
        if (DEBUG_LOG_ENABLED) {
            Log.d((String)TAG, (String)(string2 + "[" + byArray.length + "] [" + AESCrypt.bytesToHex(byArray) + "]"));
        }
    }

    private static void log(String string2, String string3) {
        if (DEBUG_LOG_ENABLED) {
            Log.d((String)TAG, (String)(string2 + "[" + string3.length() + "] [" + string3 + "]"));
        }
    }

    private static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = new char[byArray.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray2[i2 * 2] = cArray[n2 >>> 4];
            cArray2[i2 * 2 + 1] = cArray[n2 & 0xF];
        }
        return new String(cArray2);
    }

    private AESCrypt() {
    }
}

