/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.util;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.komect.network.litepal.exceptions.DatabaseGenerateException;
import com.komect.network.litepal.tablemanager.model.ColumnModel;
import com.komect.network.litepal.tablemanager.model.TableModel;
import com.komect.network.litepal.util.BaseUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBUtility {
    private static final String TAG = "DBUtility";
    private static final String SQLITE_KEYWORDS = ",abort,add,after,all,alter,and,as,asc,autoincrement,before,begin,between,by,cascade,check,collate,column,commit,conflict,constraint,create,cross,database,deferrable,deferred,delete,desc,distinct,drop,each,end,escape,except,exclusive,exists,foreign,from,glob,group,having,in,index,inner,insert,intersect,into,is,isnull,join,like,limit,match,natural,not,notnull,null,of,offset,on,or,order,outer,plan,pragma,primary,query,raise,references,regexp,reindex,release,rename,replace,restrict,right,rollback,row,savepoint,select,set,table,temp,temporary,then,to,transaction,trigger,union,unique,update,using,vacuum,values,view,virtual,when,where,";
    private static final String KEYWORDS_COLUMN_SUFFIX = "_lpcolumn";
    private static final String REG_OPERATOR = "\\s*(=|!=|<>|<|>)";
    private static final String REG_FUZZY = "\\s+(not\\s+)?(like|between)\\s+";
    private static final String REG_COLLECTION = "\\s+(not\\s+)?(in)\\s*\\(";

    private DBUtility() {
    }

    public static String getTableNameByClassName(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if ('.' == string2.charAt(string2.length() - 1)) {
                return null;
            }
            return string2.substring(string2.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static List<String> getTableNameListByClassNameList(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null && !list.isEmpty()) {
            for (String string2 : list) {
                arrayList.add(DBUtility.getTableNameByClassName(string2));
            }
        }
        return arrayList;
    }

    public static String getTableNameByForeignColumn(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (string2.toLowerCase(Locale.US).endsWith("_id")) {
                return string2.substring(0, string2.length() - "_id".length());
            }
            return null;
        }
        return null;
    }

    public static String getIntermediateTableName(String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            String string4 = string2.toLowerCase(Locale.US).compareTo(string3.toLowerCase(Locale.US)) <= 0 ? string2 + "_" + string3 : string3 + "_" + string2;
            return string4;
        }
        return null;
    }

    public static String getGenericTableName(String string2, String string3) {
        String string4 = DBUtility.getTableNameByClassName(string2);
        return BaseUtility.changeCase(string4 + "_" + string3);
    }

    public static String getGenericValueIdColumnName(String string2) {
        return BaseUtility.changeCase(DBUtility.getTableNameByClassName(string2) + "_id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isIntermediateTable(String string2, SQLiteDatabase sQLiteDatabase) {
        block10: {
            if (!TextUtils.isEmpty((CharSequence)string2) && string2.matches("[0-9a-zA-Z]+_[0-9a-zA-Z]+")) {
                try (Cursor cursor = null;){
                    cursor = sQLiteDatabase.query("table_schema", null, null, null, null, null, null);
                    if (!cursor.moveToFirst()) break block10;
                    do {
                        String string3;
                        if (!string2.equalsIgnoreCase(string3 = cursor.getString(cursor.getColumnIndexOrThrow("name")))) continue;
                        int n2 = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
                        if (n2 == 1) {
                            boolean bl2 = true;
                            return bl2;
                        }
                        break;
                    } while (cursor.moveToNext());
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGenericTable(String string2, SQLiteDatabase sQLiteDatabase) {
        block10: {
            if (!TextUtils.isEmpty((CharSequence)string2) && string2.matches("[0-9a-zA-Z]+_[0-9a-zA-Z]+")) {
                try (Cursor cursor = null;){
                    cursor = sQLiteDatabase.query("table_schema", null, null, null, null, null, null);
                    if (!cursor.moveToFirst()) break block10;
                    do {
                        String string3;
                        if (!string2.equalsIgnoreCase(string3 = cursor.getString(cursor.getColumnIndexOrThrow("name")))) continue;
                        int n2 = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
                        if (n2 == 2) {
                            boolean bl2 = true;
                            return bl2;
                        }
                        break;
                    } while (cursor.moveToNext());
                }
            }
        }
        return false;
    }

    public static boolean isTableExists(String string2, SQLiteDatabase sQLiteDatabase) {
        boolean bl2;
        try {
            bl2 = BaseUtility.containsIgnoreCases(DBUtility.findAllTableNames(sQLiteDatabase), string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = false;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isColumnExists(String string2, String string3, SQLiteDatabase sQLiteDatabase) {
        boolean bl2;
        block8: {
            if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
                return false;
            }
            bl2 = false;
            try (Cursor cursor = null;){
                String string4 = "pragma table_info(" + string3 + ")";
                cursor = sQLiteDatabase.rawQuery(string4, null);
                if (!cursor.moveToFirst()) break block8;
                do {
                    String string5;
                    if (!string2.equalsIgnoreCase(string5 = cursor.getString(cursor.getColumnIndexOrThrow("name")))) continue;
                    bl2 = true;
                    break;
                } while (cursor.moveToNext());
            }
        }
        return bl2;
    }

    public static List<String> findAllTableNames(SQLiteDatabase sQLiteDatabase) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("select * from sqlite_master where type = ?", new String[]{"table"});
            if (cursor.moveToFirst()) {
                do {
                    String string2;
                    if (arrayList.contains(string2 = cursor.getString(cursor.getColumnIndexOrThrow("tbl_name")))) continue;
                    arrayList.add(string2);
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    public static TableModel findPragmaTableInfo(String string2, SQLiteDatabase sQLiteDatabase) {
        if (DBUtility.isTableExists(string2, sQLiteDatabase)) {
            List<String> list = DBUtility.findUniqueColumns(string2, sQLiteDatabase);
            TableModel tableModel = new TableModel();
            tableModel.setTableName(string2);
            String string3 = "pragma table_info(" + string2 + ")";
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string3, null);
                if (cursor.moveToFirst()) {
                    do {
                        ColumnModel columnModel = new ColumnModel();
                        String string4 = cursor.getString(cursor.getColumnIndexOrThrow("name"));
                        String string5 = cursor.getString(cursor.getColumnIndexOrThrow("type"));
                        boolean bl2 = cursor.getInt(cursor.getColumnIndexOrThrow("notnull")) != 1;
                        boolean bl3 = list.contains(string4);
                        String string6 = cursor.getString(cursor.getColumnIndexOrThrow("dflt_value"));
                        columnModel.setColumnName(string4);
                        columnModel.setColumnType(string5);
                        columnModel.setNullable(bl2);
                        columnModel.setUnique(bl3);
                        string6 = string6 != null ? string6.replace("'", "") : "";
                        columnModel.setDefaultValue(string6);
                        tableModel.addColumnModel(columnModel);
                    } while (cursor.moveToNext());
                }
            }
            return tableModel;
        }
        throw new DatabaseGenerateException("Table doesn't exist when executing " + string2);
    }

    public static List<String> findUniqueColumns(String string2, SQLiteDatabase sQLiteDatabase) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Cursor cursor = null;
        Cursor cursor2 = null;
        try {
            cursor = sQLiteDatabase.rawQuery("pragma index_list(" + string2 + ")", null);
            if (cursor.moveToFirst()) {
                do {
                    int n2;
                    if ((n2 = cursor.getInt(cursor.getColumnIndexOrThrow("unique"))) != 1) continue;
                    String string3 = cursor.getString(cursor.getColumnIndexOrThrow("name"));
                    cursor2 = sQLiteDatabase.rawQuery("pragma index_info(" + string3 + ")", null);
                    if (!cursor2.moveToFirst()) continue;
                    String string4 = cursor2.getString(cursor2.getColumnIndexOrThrow("name"));
                    arrayList.add(string4);
                } while (cursor.moveToNext());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new DatabaseGenerateException(exception.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return arrayList;
    }

    public static boolean isFieldNameConflictWithSQLiteKeywords(String string2) {
        String string3;
        return !TextUtils.isEmpty((CharSequence)string2) && SQLITE_KEYWORDS.contains(string3 = "," + string2.toLowerCase(Locale.US) + ",");
    }

    public static String convertToValidColumnName(String string2) {
        if (DBUtility.isFieldNameConflictWithSQLiteKeywords(string2)) {
            return string2 + KEYWORDS_COLUMN_SUFFIX;
        }
        return string2;
    }

    public static String convertWhereClauseToColumnName(String string2) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Pattern pattern = Pattern.compile("(\\w+\\s*(=|!=|<>|<|>)|\\w+\\s+(not\\s+)?(like|between)\\s+|\\w+\\s+(not\\s+)?(in)\\s*\\()");
            Matcher matcher = pattern.matcher(string2);
            while (matcher.find()) {
                String string3 = matcher.group();
                String string4 = string3.replaceAll("(\\s*(=|!=|<>|<|>)|\\s+(not\\s+)?(like|between)\\s+|\\s+(not\\s+)?(in)\\s*\\()", "");
                String string5 = string3.replace(string4, "");
                string4 = DBUtility.convertToValidColumnName(string4);
                matcher.appendReplacement(stringBuffer, string4 + string5);
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string2;
        }
    }

    public static String[] convertSelectClauseToValidNames(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray2[i2] = DBUtility.convertToValidColumnName(stringArray[i2]);
            }
            return stringArray2;
        }
        return null;
    }

    public static String convertOrderByClauseToValidName(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if ((string2 = string2.trim().toLowerCase(Locale.US)).contains(",")) {
                String[] stringArray = string2.split(",");
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = false;
                for (String string3 : stringArray) {
                    if (bl2) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(DBUtility.convertOrderByItem(string3));
                    bl2 = true;
                }
                string2 = stringBuilder.toString();
            } else {
                string2 = DBUtility.convertOrderByItem(string2);
            }
            return string2;
        }
        return null;
    }

    private static String convertOrderByItem(String string2) {
        String string3 = null;
        String string4 = null;
        if (string2.endsWith("asc")) {
            string3 = string2.replace("asc", "").trim();
            string4 = " asc";
        } else if (string2.endsWith("desc")) {
            string3 = string2.replace("desc", "").trim();
            string4 = " desc";
        } else {
            string3 = string2;
            string4 = "";
        }
        return DBUtility.convertToValidColumnName(string3) + string4;
    }
}

