/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.tablemanager;

import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.tablemanager.AssociationUpdater;
import com.komect.network.litepal.tablemanager.model.ColumnModel;
import com.komect.network.litepal.tablemanager.model.TableModel;
import com.komect.network.litepal.util.DBUtility;
import com.komect.network.litepal.util.LogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Upgrader
extends AssociationUpdater {
    protected TableModel mTableModel;
    protected TableModel mTableModelDB;
    private boolean hasConstraintChanged;

    @Override
    protected void createOrUpgradeTable(SQLiteDatabase sQLiteDatabase, boolean bl2) {
        this.mDb = sQLiteDatabase;
        Iterator<TableModel> iterator = this.getAllTableModels().iterator();
        while (iterator.hasNext()) {
            TableModel tableModel;
            this.mTableModel = tableModel = iterator.next();
            this.mTableModelDB = this.getTableModelFromDB(tableModel.getTableName());
            LogUtil.d("AssociationUpdater", "createOrUpgradeTable: model is " + this.mTableModel.getTableName());
            this.upgradeTable();
        }
    }

    private void upgradeTable() {
        if (this.hasNewUniqueOrNotNullColumn()) {
            this.createOrUpgradeTable(this.mTableModel, this.mDb, true);
            Collection<AssociationsInfo> collection = this.getAssociationInfo(this.mTableModel.getClassName());
            for (AssociationsInfo associationsInfo : collection) {
                if (associationsInfo.getAssociationType() != 2 && associationsInfo.getAssociationType() != 1 || !associationsInfo.getClassHoldsForeignKey().equalsIgnoreCase(this.mTableModel.getClassName())) continue;
                String string2 = DBUtility.getTableNameByClassName(associationsInfo.getAssociatedClassName());
                this.addForeignKeyColumn(this.mTableModel.getTableName(), string2, this.mTableModel.getTableName(), this.mDb);
            }
        } else {
            this.hasConstraintChanged = false;
            this.removeColumns(this.findColumnsToRemove());
            this.addColumns(this.findColumnsToAdd());
            this.changeColumnsType(this.findColumnTypesToChange());
            this.changeColumnsConstraints();
        }
    }

    private boolean hasNewUniqueOrNotNullColumn() {
        List<ColumnModel> list = this.mTableModel.getColumnModels();
        for (ColumnModel columnModel : list) {
            ColumnModel columnModel2 = this.mTableModelDB.getColumnModelByName(columnModel.getColumnName());
            if (columnModel.isUnique() && (columnModel2 == null || !columnModel2.isUnique())) {
                return true;
            }
            if (columnModel2 == null || columnModel.isNullable() || !columnModel2.isNullable()) continue;
            return true;
        }
        return false;
    }

    private List<ColumnModel> findColumnsToAdd() {
        ArrayList<ColumnModel> arrayList = new ArrayList<ColumnModel>();
        for (ColumnModel columnModel : this.mTableModel.getColumnModels()) {
            String string2 = columnModel.getColumnName();
            if (this.mTableModelDB.containsColumn(string2)) continue;
            arrayList.add(columnModel);
        }
        return arrayList;
    }

    private List<String> findColumnsToRemove() {
        String string2 = this.mTableModel.getTableName();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ColumnModel> list = this.mTableModelDB.getColumnModels();
        for (ColumnModel columnModel : list) {
            String string3 = columnModel.getColumnName();
            if (!this.isNeedToRemove(string3)) continue;
            arrayList.add(string3);
        }
        LogUtil.d("AssociationUpdater", "remove columns from " + string2 + " >> " + arrayList);
        return arrayList;
    }

    private List<ColumnModel> findColumnTypesToChange() {
        ArrayList<ColumnModel> arrayList = new ArrayList<ColumnModel>();
        for (ColumnModel columnModel : this.mTableModelDB.getColumnModels()) {
            for (ColumnModel columnModel2 : this.mTableModel.getColumnModels()) {
                if (!columnModel.getColumnName().equalsIgnoreCase(columnModel2.getColumnName())) continue;
                if (!(columnModel.getColumnType().equalsIgnoreCase(columnModel2.getColumnType()) || columnModel2.getColumnType().equalsIgnoreCase("blob") && TextUtils.isEmpty((CharSequence)columnModel.getColumnType()))) {
                    arrayList.add(columnModel2);
                }
                if (this.hasConstraintChanged) continue;
                LogUtil.d("AssociationUpdater", "default value db is:" + columnModel.getDefaultValue() + ", default value is:" + columnModel2.getDefaultValue());
                if (columnModel.isNullable() == columnModel2.isNullable() && columnModel.getDefaultValue().equalsIgnoreCase(columnModel2.getDefaultValue()) && (!columnModel.isUnique() || columnModel2.isUnique())) continue;
                this.hasConstraintChanged = true;
            }
        }
        return arrayList;
    }

    private boolean isNeedToRemove(String string2) {
        return this.isRemovedFromClass(string2) && !this.isIdColumn(string2) && !this.isForeignKeyColumn(this.mTableModel, string2);
    }

    private boolean isRemovedFromClass(String string2) {
        return !this.mTableModel.containsColumn(string2);
    }

    private String generateAddColumnSQL(ColumnModel columnModel) {
        return this.generateAddColumnSQL(this.mTableModel.getTableName(), columnModel);
    }

    private List<String> getAddColumnSQLs(List<ColumnModel> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ColumnModel columnModel : list) {
            arrayList.add(this.generateAddColumnSQL(columnModel));
        }
        return arrayList;
    }

    private void removeColumns(List<String> list) {
        LogUtil.d("AssociationUpdater", "do removeColumns " + list);
        this.removeColumns(list, this.mTableModel.getTableName());
        for (String string2 : list) {
            this.mTableModelDB.removeColumnModelByName(string2);
        }
    }

    private void addColumns(List<ColumnModel> list) {
        LogUtil.d("AssociationUpdater", "do addColumn");
        this.execute(this.getAddColumnSQLs(list), this.mDb);
        for (ColumnModel columnModel : list) {
            this.mTableModelDB.addColumnModel(columnModel);
        }
    }

    private void changeColumnsType(List<ColumnModel> list) {
        LogUtil.d("AssociationUpdater", "do changeColumnsType");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null && !list.isEmpty()) {
            for (ColumnModel columnModel : list) {
                arrayList.add(columnModel.getColumnName());
            }
        }
        this.removeColumns(arrayList);
        this.addColumns(list);
    }

    private void changeColumnsConstraints() {
        if (this.hasConstraintChanged) {
            LogUtil.d("AssociationUpdater", "do changeColumnsConstraints");
            this.execute(this.getChangeColumnsConstraintsSQL(), this.mDb);
        }
    }

    private List<String> getChangeColumnsConstraintsSQL() {
        String string2 = this.generateAlterToTempTableSQL(this.mTableModel.getTableName());
        String string3 = this.generateCreateTableSQL(this.mTableModel);
        List<String> list = this.generateAddForeignKeySQL();
        String string4 = this.generateDataMigrationSQL(this.mTableModelDB);
        String string5 = this.generateDropTempTableSQL(this.mTableModel.getTableName());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.addAll(list);
        arrayList.add(string4);
        arrayList.add(string5);
        LogUtil.d("AssociationUpdater", "generateChangeConstraintSQL >> ");
        for (String string6 : arrayList) {
            LogUtil.d("AssociationUpdater", string6);
        }
        LogUtil.d("AssociationUpdater", "<< generateChangeConstraintSQL");
        return arrayList;
    }

    private List<String> generateAddForeignKeySQL() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.getForeignKeyColumns(this.mTableModel);
        for (String string2 : list) {
            if (this.mTableModel.containsColumn(string2)) continue;
            ColumnModel columnModel = new ColumnModel();
            columnModel.setColumnName(string2);
            columnModel.setColumnType("integer");
            arrayList.add(this.generateAddColumnSQL(this.mTableModel.getTableName(), columnModel));
        }
        return arrayList;
    }
}

