/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.tablemanager;

import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.komect.network.litepal.LitePalBase;
import com.komect.network.litepal.exceptions.DatabaseGenerateException;
import com.komect.network.litepal.parser.LitePalAttr;
import com.komect.network.litepal.tablemanager.Creator;
import com.komect.network.litepal.tablemanager.Dropper;
import com.komect.network.litepal.tablemanager.Upgrader;
import com.komect.network.litepal.tablemanager.model.AssociationsModel;
import com.komect.network.litepal.tablemanager.model.TableModel;
import com.komect.network.litepal.util.BaseUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class Generator
extends LitePalBase {
    public static final String TAG = "Generator";
    private Collection<TableModel> mTableModels;
    private Collection<AssociationsModel> mAllRelationModels;

    protected Collection<TableModel> getAllTableModels() {
        if (this.mTableModels == null) {
            this.mTableModels = new ArrayList<TableModel>();
        }
        if (!this.canUseCache()) {
            this.mTableModels.clear();
            for (String string2 : LitePalAttr.getInstance().getClassNames()) {
                this.mTableModels.add(this.getTableModel(string2));
            }
        }
        return this.mTableModels;
    }

    protected Collection<AssociationsModel> getAllAssociations() {
        if (this.mAllRelationModels == null || this.mAllRelationModels.isEmpty()) {
            this.mAllRelationModels = this.getAssociations(LitePalAttr.getInstance().getClassNames());
        }
        return this.mAllRelationModels;
    }

    protected void execute(List<String> list, SQLiteDatabase sQLiteDatabase) {
        String string2 = "";
        try {
            if (list != null && !list.isEmpty()) {
                for (String string3 : list) {
                    if (TextUtils.isEmpty((CharSequence)string3)) continue;
                    string2 = BaseUtility.changeCase(string3);
                    sQLiteDatabase.execSQL(string2);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseGenerateException("An exception that indicates there was an error with SQL parsing or execution. " + string2);
        }
    }

    private static void addAssociation(SQLiteDatabase sQLiteDatabase, boolean bl2) {
        Creator creator = new Creator();
        creator.addOrUpdateAssociation(sQLiteDatabase, bl2);
    }

    private static void updateAssociations(SQLiteDatabase sQLiteDatabase) {
        Upgrader upgrader = new Upgrader();
        upgrader.addOrUpdateAssociation(sQLiteDatabase, false);
    }

    private static void upgradeTables(SQLiteDatabase sQLiteDatabase) {
        Upgrader upgrader = new Upgrader();
        upgrader.createOrUpgradeTable(sQLiteDatabase, false);
    }

    private static void create(SQLiteDatabase sQLiteDatabase, boolean bl2) {
        Creator creator = new Creator();
        creator.createOrUpgradeTable(sQLiteDatabase, bl2);
    }

    private static void drop(SQLiteDatabase sQLiteDatabase) {
        Dropper dropper = new Dropper();
        dropper.createOrUpgradeTable(sQLiteDatabase, false);
    }

    private boolean canUseCache() {
        if (this.mTableModels == null) {
            return false;
        }
        return this.mTableModels.size() == LitePalAttr.getInstance().getClassNames().size();
    }

    static void create(SQLiteDatabase sQLiteDatabase) {
        Generator.create(sQLiteDatabase, true);
        Generator.addAssociation(sQLiteDatabase, true);
    }

    static void upgrade(SQLiteDatabase sQLiteDatabase) {
        Generator.drop(sQLiteDatabase);
        Generator.create(sQLiteDatabase, false);
        Generator.updateAssociations(sQLiteDatabase);
        Generator.upgradeTables(sQLiteDatabase);
        Generator.addAssociation(sQLiteDatabase, false);
    }

    protected abstract void createOrUpgradeTable(SQLiteDatabase var1, boolean var2);

    protected abstract void addOrUpdateAssociation(SQLiteDatabase var1, boolean var2);
}

