/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.tablemanager;

import android.database.sqlite.SQLiteDatabase;
import com.komect.network.litepal.tablemanager.AssociationCreator;
import com.komect.network.litepal.tablemanager.model.TableModel;
import com.komect.network.litepal.util.DBUtility;
import java.util.ArrayList;
import java.util.List;

class Creator
extends AssociationCreator {
    public static final String TAG = "Creator";

    Creator() {
    }

    @Override
    protected void createOrUpgradeTable(SQLiteDatabase sQLiteDatabase, boolean bl2) {
        for (TableModel tableModel : this.getAllTableModels()) {
            this.createOrUpgradeTable(tableModel, sQLiteDatabase, bl2);
        }
    }

    protected void createOrUpgradeTable(TableModel tableModel, SQLiteDatabase sQLiteDatabase, boolean bl2) {
        this.execute(this.getCreateTableSQLs(tableModel, sQLiteDatabase, bl2), sQLiteDatabase);
        this.giveTableSchemaACopy(tableModel.getTableName(), 0, sQLiteDatabase);
    }

    protected List<String> getCreateTableSQLs(TableModel tableModel, SQLiteDatabase sQLiteDatabase, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl2) {
            arrayList.add(this.generateDropTableSQL(tableModel));
            arrayList.add(this.generateCreateTableSQL(tableModel));
        } else {
            if (DBUtility.isTableExists(tableModel.getTableName(), sQLiteDatabase)) {
                return null;
            }
            arrayList.add(this.generateCreateTableSQL(tableModel));
        }
        return arrayList;
    }

    private String generateDropTableSQL(TableModel tableModel) {
        return this.generateDropTableSQL(tableModel.getTableName());
    }

    String generateCreateTableSQL(TableModel tableModel) {
        return this.generateCreateTableSQL(tableModel.getTableName(), tableModel.getColumnModels(), true);
    }
}

