/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.tablemanager;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import com.komect.network.litepal.LitePalApplication;
import com.komect.network.litepal.exceptions.DatabaseGenerateException;
import com.komect.network.litepal.parser.LitePalAttr;
import com.komect.network.litepal.tablemanager.LitePalOpenHelper;
import com.komect.network.litepal.util.BaseUtility;
import java.io.File;

public class Connector {
    private static LitePalOpenHelper mLitePalHelper;

    public static synchronized SQLiteDatabase getWritableDatabase() {
        LitePalOpenHelper litePalOpenHelper = Connector.buildConnection();
        return litePalOpenHelper.getWritableDatabase();
    }

    @Deprecated
    public static synchronized SQLiteDatabase getReadableDatabase() {
        LitePalOpenHelper litePalOpenHelper = Connector.buildConnection();
        return litePalOpenHelper.getReadableDatabase();
    }

    public static SQLiteDatabase getDatabase() {
        return Connector.getWritableDatabase();
    }

    private static LitePalOpenHelper buildConnection() {
        LitePalAttr litePalAttr = LitePalAttr.getInstance();
        litePalAttr.checkSelfValid();
        if (mLitePalHelper == null) {
            String string2 = litePalAttr.getDbName();
            if ("external".equalsIgnoreCase(litePalAttr.getStorage())) {
                string2 = LitePalApplication.getContext().getExternalFilesDir("") + "/databases/" + string2;
            } else if (!"internal".equalsIgnoreCase(litePalAttr.getStorage()) && !TextUtils.isEmpty((CharSequence)litePalAttr.getStorage())) {
                String string3 = Environment.getExternalStorageDirectory().getPath() + "/" + litePalAttr.getStorage();
                string3 = string3.replace("//", "/");
                if (BaseUtility.isClassAndMethodExist("android.support.v4.content.ContextCompat", "checkSelfPermission") && ContextCompat.checkSelfPermission((Context)LitePalApplication.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                    throw new DatabaseGenerateException(String.format("You don't have permission to access database at %1$s. Make sure you handled WRITE_EXTERNAL_STORAGE runtime permission correctly.", string3));
                }
                File file = new File(string3);
                if (!file.exists()) {
                    file.mkdirs();
                }
                string2 = string3 + "/" + string2;
            }
            mLitePalHelper = new LitePalOpenHelper(string2, litePalAttr.getVersion());
        }
        return mLitePalHelper;
    }

    public static void clearLitePalOpenHelperInstance() {
        if (mLitePalHelper != null) {
            mLitePalHelper.getWritableDatabase().close();
            mLitePalHelper = null;
        }
    }
}

