/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.tablemanager;

import android.database.sqlite.SQLiteDatabase;
import com.komect.network.litepal.parser.LitePalAttr;
import com.komect.network.litepal.tablemanager.Creator;
import com.komect.network.litepal.tablemanager.model.AssociationsModel;
import com.komect.network.litepal.tablemanager.model.ColumnModel;
import com.komect.network.litepal.tablemanager.model.GenericModel;
import com.komect.network.litepal.tablemanager.model.TableModel;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import com.komect.network.litepal.util.LogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AssociationUpdater
extends Creator {
    public static final String TAG = "AssociationUpdater";
    private Collection<AssociationsModel> mAssociationModels;
    protected SQLiteDatabase mDb;

    @Override
    protected abstract void createOrUpgradeTable(SQLiteDatabase var1, boolean var2);

    @Override
    protected void addOrUpdateAssociation(SQLiteDatabase sQLiteDatabase, boolean bl2) {
        this.mAssociationModels = this.getAllAssociations();
        this.mDb = sQLiteDatabase;
        this.removeAssociations();
    }

    protected List<String> getForeignKeyColumns(TableModel tableModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ColumnModel> list = this.getTableModelFromDB(tableModel.getTableName()).getColumnModels();
        for (ColumnModel columnModel : list) {
            String string2 = columnModel.getColumnName();
            if (!this.isForeignKeyColumnFormat(columnModel.getColumnName()) || tableModel.containsColumn(string2)) continue;
            LogUtil.d(TAG, "getForeignKeyColumnNames >> foreign key column is " + string2);
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected boolean isForeignKeyColumn(TableModel tableModel, String string2) {
        return BaseUtility.containsIgnoreCases(this.getForeignKeyColumns(tableModel), string2);
    }

    protected TableModel getTableModelFromDB(String string2) {
        return DBUtility.findPragmaTableInfo(string2, this.mDb);
    }

    protected void dropTables(List<String> list, SQLiteDatabase sQLiteDatabase) {
        if (list != null && !list.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                arrayList.add(this.generateDropTableSQL(list.get(i2)));
            }
            this.execute(arrayList, sQLiteDatabase);
        }
    }

    protected void removeColumns(Collection<String> collection, String string2) {
        if (collection != null && !collection.isEmpty()) {
            this.execute(this.getRemoveColumnSQLs(collection, string2), this.mDb);
        }
    }

    protected void clearCopyInTableSchema(List<String> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("delete from ");
            stringBuilder.append("table_schema").append(" where");
            boolean bl2 = false;
            for (String string2 : list) {
                if (bl2) {
                    stringBuilder.append(" or ");
                }
                bl2 = true;
                stringBuilder.append(" lower(").append("name").append(") ");
                stringBuilder.append("=").append(" lower('").append(string2).append("')");
            }
            LogUtil.d(TAG, "clear table schema value sql is " + stringBuilder);
            ArrayList arrayList = new ArrayList();
            arrayList.add(stringBuilder.toString());
            this.execute(arrayList, this.mDb);
        }
    }

    private void removeAssociations() {
        this.removeForeignKeyColumns();
        this.removeIntermediateTables();
        this.removeGenericTables();
    }

    private void removeForeignKeyColumns() {
        for (String string2 : LitePalAttr.getInstance().getClassNames()) {
            TableModel tableModel = this.getTableModel(string2);
            this.removeColumns(this.findForeignKeyToRemove(tableModel), tableModel.getTableName());
        }
    }

    private void removeIntermediateTables() {
        List<String> list = this.findIntermediateTablesToDrop();
        this.dropTables(list, this.mDb);
        this.clearCopyInTableSchema(list);
    }

    private void removeGenericTables() {
        List<String> list = this.findGenericTablesToDrop();
        this.dropTables(list, this.mDb);
        this.clearCopyInTableSchema(list);
    }

    private List<String> findForeignKeyToRemove(TableModel tableModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.getForeignKeyColumns(tableModel);
        String string2 = tableModel.getTableName();
        for (String string3 : list) {
            String string4 = DBUtility.getTableNameByForeignColumn(string3);
            if (!this.shouldDropForeignKey(string2, string4)) continue;
            arrayList.add(string3);
        }
        LogUtil.d(TAG, "findForeignKeyToRemove >> " + tableModel.getTableName() + " " + arrayList);
        return arrayList;
    }

    private List<String> findIntermediateTablesToDrop() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : DBUtility.findAllTableNames(this.mDb)) {
            if (!DBUtility.isIntermediateTable(string2, this.mDb)) continue;
            boolean bl2 = true;
            for (AssociationsModel associationsModel : this.mAssociationModels) {
                String string3;
                if (associationsModel.getAssociationType() != 3 || !string2.equalsIgnoreCase(string3 = DBUtility.getIntermediateTableName(associationsModel.getTableName(), associationsModel.getAssociatedTableName()))) continue;
                bl2 = false;
            }
            if (!bl2) continue;
            arrayList.add(string2);
        }
        LogUtil.d(TAG, "findIntermediateTablesToDrop >> " + arrayList);
        return arrayList;
    }

    private List<String> findGenericTablesToDrop() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : DBUtility.findAllTableNames(this.mDb)) {
            if (!DBUtility.isGenericTable(string2, this.mDb)) continue;
            boolean bl2 = true;
            for (GenericModel genericModel : this.getGenericModels()) {
                String string3 = genericModel.getTableName();
                if (!string2.equalsIgnoreCase(string3)) continue;
                bl2 = false;
            }
            if (!bl2) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected String generateAlterToTempTableSQL(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("alter table ").append(string2).append(" rename to ").append(this.getTempTableName(string2));
        return stringBuilder.toString();
    }

    private String generateCreateNewTableSQL(Collection<String> collection, TableModel tableModel) {
        for (String string2 : collection) {
            tableModel.removeColumnModelByName(string2);
        }
        return this.generateCreateTableSQL(tableModel);
    }

    protected String generateDataMigrationSQL(TableModel tableModel) {
        String string2 = tableModel.getTableName();
        List<ColumnModel> list = tableModel.getColumnModels();
        if (!list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("insert into ").append(string2).append("(");
            boolean bl2 = false;
            for (ColumnModel columnModel : list) {
                if (bl2) {
                    stringBuilder.append(", ");
                }
                bl2 = true;
                stringBuilder.append(columnModel.getColumnName());
            }
            stringBuilder.append(") ");
            stringBuilder.append("select ");
            bl2 = false;
            for (ColumnModel columnModel : list) {
                if (bl2) {
                    stringBuilder.append(", ");
                }
                bl2 = true;
                stringBuilder.append(columnModel.getColumnName());
            }
            stringBuilder.append(" from ").append(this.getTempTableName(string2));
            return stringBuilder.toString();
        }
        return null;
    }

    protected String generateDropTempTableSQL(String string2) {
        return this.generateDropTableSQL(this.getTempTableName(string2));
    }

    protected String getTempTableName(String string2) {
        return string2 + "_temp";
    }

    private List<String> getRemoveColumnSQLs(Collection<String> collection, String string2) {
        TableModel tableModel = this.getTableModelFromDB(string2);
        String string3 = this.generateAlterToTempTableSQL(string2);
        LogUtil.d(TAG, "generateRemoveColumnSQL >> " + string3);
        String string4 = this.generateCreateNewTableSQL(collection, tableModel);
        LogUtil.d(TAG, "generateRemoveColumnSQL >> " + string4);
        String string5 = this.generateDataMigrationSQL(tableModel);
        LogUtil.d(TAG, "generateRemoveColumnSQL >> " + string5);
        String string6 = this.generateDropTempTableSQL(string2);
        LogUtil.d(TAG, "generateRemoveColumnSQL >> " + string6);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        arrayList.add(string6);
        return arrayList;
    }

    private boolean shouldDropForeignKey(String string2, String string3) {
        for (AssociationsModel associationsModel : this.mAssociationModels) {
            if (!(associationsModel.getAssociationType() == 1 ? string2.equalsIgnoreCase(associationsModel.getTableHoldsForeignKey()) && (associationsModel.getTableName().equalsIgnoreCase(string2) ? this.isRelationCorrect(associationsModel, string2, string3) : associationsModel.getAssociatedTableName().equalsIgnoreCase(string2) && this.isRelationCorrect(associationsModel, string3, string2)) : associationsModel.getAssociationType() == 2 && this.isRelationCorrect(associationsModel, string3, string2))) continue;
            return false;
        }
        return true;
    }

    private boolean isRelationCorrect(AssociationsModel associationsModel, String string2, String string3) {
        return associationsModel.getTableName().equalsIgnoreCase(string2) && associationsModel.getAssociatedTableName().equalsIgnoreCase(string3);
    }
}

