/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.tablemanager;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.komect.network.litepal.exceptions.DatabaseGenerateException;
import com.komect.network.litepal.tablemanager.Generator;
import com.komect.network.litepal.tablemanager.model.AssociationsModel;
import com.komect.network.litepal.tablemanager.model.ColumnModel;
import com.komect.network.litepal.tablemanager.model.GenericModel;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import com.komect.network.litepal.util.LogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public abstract class AssociationCreator
extends Generator {
    @Override
    protected abstract void createOrUpgradeTable(SQLiteDatabase var1, boolean var2);

    @Override
    protected void addOrUpdateAssociation(SQLiteDatabase sQLiteDatabase, boolean bl2) {
        this.addAssociations(this.getAllAssociations(), sQLiteDatabase, bl2);
    }

    protected String generateCreateTableSQL(String string2, List<ColumnModel> list, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder("create table ");
        stringBuilder.append(string2).append(" (");
        if (bl2) {
            stringBuilder.append("id integer primary key autoincrement,");
        }
        if (this.isContainsOnlyIdField(list)) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        boolean bl3 = false;
        for (ColumnModel columnModel : list) {
            String string3;
            if (columnModel.isIdColumn()) continue;
            if (bl3) {
                stringBuilder.append(", ");
            }
            bl3 = true;
            stringBuilder.append(columnModel.getColumnName()).append(" ").append(columnModel.getColumnType());
            if (!columnModel.isNullable()) {
                stringBuilder.append(" not null");
            }
            if (columnModel.isUnique()) {
                stringBuilder.append(" unique");
            }
            if (TextUtils.isEmpty((CharSequence)(string3 = columnModel.getDefaultValue()))) continue;
            stringBuilder.append(" default ").append(string3);
        }
        stringBuilder.append(")");
        LogUtil.d("Generator", "create table sql is >> " + stringBuilder);
        return stringBuilder.toString();
    }

    protected String generateDropTableSQL(String string2) {
        return "drop table if exists " + string2;
    }

    protected String generateAddColumnSQL(String string2, ColumnModel columnModel) {
        String string3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("alter table ").append(string2);
        stringBuilder.append(" add column ").append(columnModel.getColumnName());
        stringBuilder.append(" ").append(columnModel.getColumnType());
        if (!columnModel.isNullable()) {
            stringBuilder.append(" not null");
        }
        if (columnModel.isUnique()) {
            stringBuilder.append(" unique");
        }
        if (!TextUtils.isEmpty((CharSequence)(string3 = columnModel.getDefaultValue()))) {
            stringBuilder.append(" default ").append(string3);
        } else if (!columnModel.isNullable()) {
            if ("integer".equalsIgnoreCase(columnModel.getColumnType())) {
                string3 = "0";
            } else if ("text".equalsIgnoreCase(columnModel.getColumnType())) {
                string3 = "''";
            } else if ("real".equalsIgnoreCase(columnModel.getColumnType())) {
                string3 = "0.0";
            }
            stringBuilder.append(" default ").append(string3);
        }
        LogUtil.d("Generator", "add column sql is >> " + stringBuilder);
        return stringBuilder.toString();
    }

    protected boolean isForeignKeyColumnFormat(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2.toLowerCase(Locale.US).endsWith("_id") && !string2.equalsIgnoreCase("_id");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void giveTableSchemaACopy(String string2, int n2, SQLiteDatabase sQLiteDatabase) {
        StringBuilder stringBuilder = new StringBuilder("select * from ");
        stringBuilder.append("table_schema");
        LogUtil.d("Generator", "giveTableSchemaACopy SQL is >> " + stringBuilder);
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(stringBuilder.toString(), null);
            if (this.isNeedtoGiveACopy(cursor, string2)) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("name", BaseUtility.changeCase(string2));
                contentValues.put("type", Integer.valueOf(n2));
                sQLiteDatabase.insert("table_schema", null, contentValues);
            }
        }
    }

    private boolean isNeedtoGiveACopy(Cursor cursor, String string2) {
        return !this.isValueExists(cursor, string2) && !this.isSpecialTable(string2);
    }

    private boolean isValueExists(Cursor cursor, String string2) {
        boolean bl2 = false;
        if (cursor.moveToFirst()) {
            do {
                String string3;
                if (!(string3 = cursor.getString(cursor.getColumnIndexOrThrow("name"))).equalsIgnoreCase(string2)) continue;
                bl2 = true;
                break;
            } while (cursor.moveToNext());
        }
        return bl2;
    }

    private boolean isSpecialTable(String string2) {
        return "table_schema".equalsIgnoreCase(string2);
    }

    private void addAssociations(Collection<AssociationsModel> collection, SQLiteDatabase sQLiteDatabase, boolean bl2) {
        for (AssociationsModel object : collection) {
            if (2 == object.getAssociationType() || 1 == object.getAssociationType()) {
                this.addForeignKeyColumn(object.getTableName(), object.getAssociatedTableName(), object.getTableHoldsForeignKey(), sQLiteDatabase);
                continue;
            }
            if (3 != object.getAssociationType()) continue;
            this.createIntermediateTable(object.getTableName(), object.getAssociatedTableName(), sQLiteDatabase, bl2);
        }
        for (GenericModel genericModel : this.getGenericModels()) {
            this.createGenericTable(genericModel, sQLiteDatabase, bl2);
        }
    }

    private void createIntermediateTable(String string2, String string3, SQLiteDatabase sQLiteDatabase, boolean bl2) {
        ArrayList<ColumnModel> arrayList = new ArrayList<ColumnModel>();
        ColumnModel columnModel = new ColumnModel();
        columnModel.setColumnName(string2 + "_id");
        columnModel.setColumnType("integer");
        ColumnModel columnModel2 = new ColumnModel();
        columnModel2.setColumnName(string3 + "_id");
        columnModel2.setColumnType("integer");
        arrayList.add(columnModel);
        arrayList.add(columnModel2);
        String string4 = DBUtility.getIntermediateTableName(string2, string3);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (DBUtility.isTableExists(string4, sQLiteDatabase)) {
            if (bl2) {
                arrayList2.add(this.generateDropTableSQL(string4));
                arrayList2.add(this.generateCreateTableSQL(string4, arrayList, false));
            }
        } else {
            arrayList2.add(this.generateCreateTableSQL(string4, arrayList, false));
        }
        this.execute(arrayList2, sQLiteDatabase);
        this.giveTableSchemaACopy(string4, 1, sQLiteDatabase);
    }

    private void createGenericTable(GenericModel genericModel, SQLiteDatabase sQLiteDatabase, boolean bl2) {
        String string2 = genericModel.getTableName();
        String string3 = genericModel.getValueColumnName();
        String string4 = genericModel.getValueColumnType();
        String string5 = genericModel.getValueIdColumnName();
        ArrayList<ColumnModel> arrayList = new ArrayList<ColumnModel>();
        ColumnModel columnModel = new ColumnModel();
        columnModel.setColumnName(string3);
        columnModel.setColumnType(string4);
        ColumnModel columnModel2 = new ColumnModel();
        columnModel2.setColumnName(string5);
        columnModel2.setColumnType("integer");
        arrayList.add(columnModel);
        arrayList.add(columnModel2);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (DBUtility.isTableExists(string2, sQLiteDatabase)) {
            if (bl2) {
                arrayList2.add(this.generateDropTableSQL(string2));
                arrayList2.add(this.generateCreateTableSQL(string2, arrayList, false));
            }
        } else {
            arrayList2.add(this.generateCreateTableSQL(string2, arrayList, false));
        }
        this.execute(arrayList2, sQLiteDatabase);
        this.giveTableSchemaACopy(string2, 2, sQLiteDatabase);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addForeignKeyColumn(String string2, String string3, String string4, SQLiteDatabase sQLiteDatabase) {
        if (!DBUtility.isTableExists(string2, sQLiteDatabase)) throw new DatabaseGenerateException("Table doesn't exist with the name of " + string2);
        if (!DBUtility.isTableExists(string3, sQLiteDatabase)) throw new DatabaseGenerateException("Table doesn't exist with the name of " + string3);
        String string5 = null;
        if (string2.equals(string4)) {
            string5 = this.getForeignKeyColumnName(string3);
        } else if (string3.equals(string4)) {
            string5 = this.getForeignKeyColumnName(string2);
        }
        if (!DBUtility.isColumnExists(string5, string4, sQLiteDatabase)) {
            ColumnModel columnModel = new ColumnModel();
            columnModel.setColumnName(string5);
            columnModel.setColumnType("integer");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.generateAddColumnSQL(string4, columnModel));
            this.execute(arrayList, sQLiteDatabase);
            return;
        } else {
            LogUtil.d("Generator", "column " + string5 + " is already exist, no need to add one");
        }
    }

    private boolean isContainsOnlyIdField(List<ColumnModel> list) {
        return list.size() == 0 || list.size() == 1 && this.isIdColumn(list.get(0).getColumnName()) || list.size() == 2 && this.isIdColumn(list.get(0).getColumnName()) && this.isIdColumn(list.get(1).getColumnName());
    }
}

