/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.parser;

import android.content.res.AssetManager;
import android.content.res.Resources;
import com.komect.network.litepal.LitePalApplication;
import com.komect.network.litepal.exceptions.ParseConfigurationFileException;
import com.komect.network.litepal.parser.LitePalConfig;
import com.komect.network.litepal.parser.LitePalContentHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class LitePalParser {
    static final String NODE_DB_NAME = "dbname";
    static final String NODE_VERSION = "version";
    static final String NODE_LIST = "list";
    static final String NODE_MAPPING = "mapping";
    static final String NODE_CASES = "cases";
    static final String NODE_STORAGE = "storage";
    static final String ATTR_VALUE = "value";
    static final String ATTR_CLASS = "class";
    private static LitePalParser parser;

    public static LitePalConfig parseLitePalConfiguration() {
        if (parser == null) {
            parser = new LitePalParser();
        }
        return parser.usePullParse();
    }

    private void useSAXParser() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            LitePalContentHandler litePalContentHandler = new LitePalContentHandler();
            xMLReader.setContentHandler(litePalContentHandler);
            xMLReader.parse(new InputSource(this.getConfigInputStream()));
        }
        catch (Resources.NotFoundException notFoundException) {
            throw new ParseConfigurationFileException("litepal.xml file is missing. Please ensure it under assets folder.");
        }
        catch (SAXException sAXException) {
            throw new ParseConfigurationFileException("can not parse the litepal.xml, check if it's in correct format");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ParseConfigurationFileException("parse configuration is failed");
        }
        catch (IOException iOException) {
            throw new ParseConfigurationFileException("IO exception happened");
        }
    }

    private LitePalConfig usePullParse() {
        try {
            LitePalConfig litePalConfig = new LitePalConfig();
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
            xmlPullParser.setInput(this.getConfigInputStream(), "UTF-8");
            int n2 = xmlPullParser.getEventType();
            while (n2 != 1) {
                String string2 = xmlPullParser.getName();
                switch (n2) {
                    case 2: {
                        String string3;
                        if (NODE_DB_NAME.equals(string2)) {
                            string3 = xmlPullParser.getAttributeValue("", ATTR_VALUE);
                            litePalConfig.setDbName(string3);
                            break;
                        }
                        if (NODE_VERSION.equals(string2)) {
                            string3 = xmlPullParser.getAttributeValue("", ATTR_VALUE);
                            litePalConfig.setVersion(Integer.parseInt(string3));
                            break;
                        }
                        if (NODE_MAPPING.equals(string2)) {
                            string3 = xmlPullParser.getAttributeValue("", ATTR_CLASS);
                            litePalConfig.addClassName(string3);
                            break;
                        }
                        if (NODE_CASES.equals(string2)) {
                            string3 = xmlPullParser.getAttributeValue("", ATTR_VALUE);
                            litePalConfig.setCases(string3);
                            break;
                        }
                        if (!NODE_STORAGE.equals(string2)) break;
                        string3 = xmlPullParser.getAttributeValue("", ATTR_VALUE);
                        litePalConfig.setStorage(string3);
                        break;
                    }
                }
                n2 = xmlPullParser.next();
            }
            return litePalConfig;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new ParseConfigurationFileException("can not parse the litepal.xml, check if it's in correct format");
        }
        catch (IOException iOException) {
            throw new ParseConfigurationFileException("IO exception happened");
        }
    }

    private InputStream getConfigInputStream() throws IOException {
        AssetManager assetManager = LitePalApplication.getContext().getAssets();
        String[] stringArray = assetManager.list("");
        if (stringArray != null && stringArray.length > 0) {
            for (String string2 : stringArray) {
                if (!"litepal.xml".equalsIgnoreCase(string2)) continue;
                return assetManager.open(string2, 3);
            }
        }
        throw new ParseConfigurationFileException("litepal.xml file is missing. Please ensure it under assets folder.");
    }
}

