/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.crud;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import com.komect.network.litepal.annotation.Encrypt;
import com.komect.network.litepal.crud.DataHandler;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.crud.DynamicExecutor;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.exceptions.DataSupportException;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class UpdateHandler
extends DataHandler {
    UpdateHandler(SQLiteDatabase sQLiteDatabase) {
        this.mDatabase = sQLiteDatabase;
    }

    int onUpdate(DataSupport dataSupport, long l2) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        List<Field> list = this.getSupportedFields(dataSupport.getClassName());
        List<Field> list2 = this.getSupportedGenericFields(dataSupport.getClassName());
        this.updateGenericTables(dataSupport, list2, l2);
        ContentValues contentValues = new ContentValues();
        this.putFieldsValue(dataSupport, list, contentValues);
        this.putFieldsToDefaultValue(dataSupport, contentValues, l2);
        if (contentValues.size() > 0) {
            return this.mDatabase.update(dataSupport.getTableName(), contentValues, "id = " + l2, null);
        }
        return 0;
    }

    int onUpdate(Class<?> clazz, long l2, ContentValues contentValues) {
        if (contentValues.size() > 0) {
            this.convertContentValues(contentValues);
            return this.mDatabase.update(this.getTableName(clazz), contentValues, "id = " + l2, null);
        }
        return 0;
    }

    int onUpdateAll(DataSupport dataSupport, String ... stringArray) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object object;
        BaseUtility.checkConditionsCorrect(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            stringArray[0] = DBUtility.convertWhereClauseToColumnName(stringArray[0]);
        }
        List<Field> list = this.getSupportedFields(dataSupport.getClassName());
        List<Field> list2 = this.getSupportedGenericFields(dataSupport.getClassName());
        long[] lArray = null;
        if (!list2.isEmpty() && (object = DataSupport.select("id").where(stringArray).find(dataSupport.getClass())).size() > 0) {
            lArray = new long[object.size()];
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                DataSupport dataSupport2 = (DataSupport)object.get(i2);
                lArray[i2] = dataSupport2.getBaseObjId();
            }
            this.updateGenericTables(dataSupport, list2, lArray);
        }
        object = new ContentValues();
        this.putFieldsValue(dataSupport, list, (ContentValues)object);
        this.putFieldsToDefaultValue(dataSupport, (ContentValues)object, lArray);
        return this.doUpdateAllAction(dataSupport.getTableName(), (ContentValues)object, stringArray);
    }

    int onUpdateAll(String string2, ContentValues contentValues, String ... stringArray) {
        BaseUtility.checkConditionsCorrect(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            stringArray[0] = DBUtility.convertWhereClauseToColumnName(stringArray[0]);
        }
        this.convertContentValues(contentValues);
        return this.doUpdateAllAction(string2, contentValues, stringArray);
    }

    private int doUpdateAllAction(String string2, ContentValues contentValues, String ... stringArray) {
        BaseUtility.checkConditionsCorrect(stringArray);
        if (contentValues.size() > 0) {
            return this.mDatabase.update(string2, contentValues, this.getWhereClause(stringArray), this.getWhereArgs(stringArray));
        }
        return 0;
    }

    private void putFieldsToDefaultValue(DataSupport dataSupport, ContentValues contentValues, long ... lArray) {
        String string2 = null;
        try {
            DataSupport dataSupport2 = this.getEmptyModel(dataSupport);
            Class<?> clazz = dataSupport2.getClass();
            for (String string3 : dataSupport.getFieldsToSetToDefault()) {
                if (this.isIdColumn(string3)) continue;
                string2 = string3;
                Field field = clazz.getDeclaredField(string2);
                if (this.isCollection(field.getType())) {
                    String string4;
                    if (lArray == null || lArray.length <= 0 || !BaseUtility.isGenericTypeSupported(string4 = this.getGenericTypeName(field))) continue;
                    String string5 = DBUtility.getGenericTableName(dataSupport.getClassName(), field.getName());
                    String string6 = DBUtility.getGenericValueIdColumnName(dataSupport.getClassName());
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl2 = false;
                    for (long l2 : lArray) {
                        if (bl2) {
                            stringBuilder.append(" or ");
                        }
                        stringBuilder.append(string6).append(" = ").append(l2);
                        bl2 = true;
                    }
                    this.mDatabase.delete(string5, stringBuilder.toString(), null);
                    continue;
                }
                this.putContentValuesForUpdate(dataSupport2, field, contentValues);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new DataSupportException(DataSupportException.noSuchFieldExceptioin(dataSupport.getClassName(), string2), noSuchFieldException);
        }
        catch (Exception exception) {
            throw new DataSupportException(exception.getMessage(), exception);
        }
    }

    private int doUpdateAssociations(DataSupport dataSupport, long l2, ContentValues contentValues) {
        int n2 = 0;
        this.analyzeAssociations(dataSupport);
        this.updateSelfTableForeignKey(dataSupport, contentValues);
        return n2 += this.updateAssociatedTableForeignKey(dataSupport, l2);
    }

    private void analyzeAssociations(DataSupport dataSupport) {
        try {
            Collection<AssociationsInfo> collection = this.getAssociationInfo(dataSupport.getClassName());
            this.analyzeAssociatedModels(dataSupport, collection);
        }
        catch (Exception exception) {
            throw new DataSupportException(exception.getMessage(), exception);
        }
    }

    private void updateSelfTableForeignKey(DataSupport dataSupport, ContentValues contentValues) {
        Map<String, Long> map = dataSupport.getAssociatedModelsMapWithoutFK();
        for (String string2 : map.keySet()) {
            String string3 = this.getForeignKeyColumnName(string2);
            contentValues.put(string3, map.get(string2));
        }
    }

    private int updateAssociatedTableForeignKey(DataSupport dataSupport, long l2) {
        Map<String, Set<Long>> map = dataSupport.getAssociatedModelsMapWithFK();
        ContentValues contentValues = new ContentValues();
        for (String string2 : map.keySet()) {
            contentValues.clear();
            String string3 = this.getForeignKeyColumnName(dataSupport.getTableName());
            contentValues.put(string3, Long.valueOf(l2));
            Set<Long> set = map.get(string2);
            if (set == null || set.isEmpty()) continue;
            return this.mDatabase.update(string2, contentValues, this.getWhereOfIdsWithOr(set), null);
        }
        return 0;
    }

    private void updateGenericTables(DataSupport dataSupport, List<Field> list, long ... lArray) throws IllegalAccessException, InvocationTargetException {
        if (lArray != null && lArray.length > 0) {
            for (Field field : list) {
                Encrypt encrypt = field.getAnnotation(Encrypt.class);
                String string2 = null;
                if (encrypt != null && "java.lang.String".equals(this.getGenericTypeName(field))) {
                    string2 = encrypt.algorithm();
                }
                field.setAccessible(true);
                Collection collection = (Collection)field.get(dataSupport);
                if (collection == null || collection.isEmpty()) continue;
                String string3 = DBUtility.getGenericTableName(dataSupport.getClassName(), field.getName());
                String string4 = DBUtility.getGenericValueIdColumnName(dataSupport.getClassName());
                for (long l2 : lArray) {
                    this.mDatabase.delete(string3, string4 + " = ?", new String[]{String.valueOf(l2)});
                    for (Object object : collection) {
                        ContentValues contentValues = new ContentValues();
                        contentValues.put(string4, Long.valueOf(l2));
                        object = this.encryptValue(string2, object);
                        Object[] objectArray = new Object[]{DBUtility.convertToValidColumnName(BaseUtility.changeCase(field.getName())), object};
                        Class[] classArray = new Class[]{String.class, this.getGenericTypeClass(field)};
                        DynamicExecutor.send(contentValues, "put", objectArray, contentValues.getClass(), classArray);
                        this.mDatabase.insert(string3, null, contentValues);
                    }
                }
            }
        }
    }

    private void convertContentValues(ContentValues contentValues) {
        if (Build.VERSION.SDK_INT >= 11) {
            Object object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string2 : contentValues.keySet()) {
                if (!DBUtility.isFieldNameConflictWithSQLiteKeywords(string2)) continue;
                object = contentValues.get(string2);
                hashMap.put(string2, object);
            }
            for (String string2 : hashMap.keySet()) {
                object = DBUtility.convertToValidColumnName(string2);
                Object object2 = contentValues.get(string2);
                contentValues.remove(string2);
                if (object2 == null) {
                    contentValues.putNull((String)object);
                    continue;
                }
                String string3 = object2.getClass().getName();
                if ("java.lang.Byte".equals(string3)) {
                    contentValues.put((String)object, (Byte)object2);
                    continue;
                }
                if ("[B".equals(string3)) {
                    contentValues.put((String)object, (byte[])object2);
                    continue;
                }
                if ("java.lang.Boolean".equals(string3)) {
                    contentValues.put((String)object, (Boolean)object2);
                    continue;
                }
                if ("java.lang.String".equals(string3)) {
                    contentValues.put((String)object, (String)object2);
                    continue;
                }
                if ("java.lang.Float".equals(string3)) {
                    contentValues.put((String)object, (Float)object2);
                    continue;
                }
                if ("java.lang.Long".equals(string3)) {
                    contentValues.put((String)object, (Long)object2);
                    continue;
                }
                if ("java.lang.Integer".equals(string3)) {
                    contentValues.put((String)object, (Integer)object2);
                    continue;
                }
                if ("java.lang.Short".equals(string3)) {
                    contentValues.put((String)object, (Short)object2);
                    continue;
                }
                if (!"java.lang.Double".equals(string3)) continue;
                contentValues.put((String)object, (Double)object2);
            }
        }
    }
}

