/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.crud;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import com.komect.network.litepal.annotation.Encrypt;
import com.komect.network.litepal.crud.DataHandler;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.crud.DynamicExecutor;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.exceptions.DataSupportException;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SaveHandler
extends DataHandler {
    private boolean ignoreAssociations = false;
    private ContentValues values = new ContentValues();

    SaveHandler(SQLiteDatabase sQLiteDatabase) {
        this.mDatabase = sQLiteDatabase;
    }

    void onSave(DataSupport dataSupport) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String string2 = dataSupport.getClassName();
        List<Field> list = this.getSupportedFields(string2);
        List<Field> list2 = this.getSupportedGenericFields(string2);
        Collection<AssociationsInfo> collection = this.getAssociationInfo(string2);
        if (!dataSupport.isSaved()) {
            if (!this.ignoreAssociations) {
                this.analyzeAssociatedModels(dataSupport, collection);
            }
            this.doSaveAction(dataSupport, list, list2);
            if (!this.ignoreAssociations) {
                this.analyzeAssociatedModels(dataSupport, collection);
            }
        } else {
            if (!this.ignoreAssociations) {
                this.analyzeAssociatedModels(dataSupport, collection);
            }
            this.doUpdateAction(dataSupport, list, list2);
        }
    }

    void onSaveFast(DataSupport dataSupport) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.ignoreAssociations = true;
        this.onSave(dataSupport);
    }

    <T extends DataSupport> void onSaveAll(Collection<T> collection) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (collection != null && collection.size() > 0) {
            DataSupport[] dataSupportArray = collection.toArray(new DataSupport[0]);
            DataSupport dataSupport = dataSupportArray[0];
            String string2 = dataSupport.getClassName();
            List<Field> list = this.getSupportedFields(string2);
            List<Field> list2 = this.getSupportedGenericFields(string2);
            Collection<AssociationsInfo> collection2 = this.getAssociationInfo(string2);
            for (DataSupport dataSupport2 : dataSupportArray) {
                if (!dataSupport2.isSaved()) {
                    this.analyzeAssociatedModels(dataSupport2, collection2);
                    this.doSaveAction(dataSupport2, list, list2);
                    this.analyzeAssociatedModels(dataSupport2, collection2);
                } else {
                    this.analyzeAssociatedModels(dataSupport2, collection2);
                    this.doUpdateAction(dataSupport2, list, list2);
                }
                dataSupport2.clearAssociatedData();
            }
        }
    }

    private void doSaveAction(DataSupport dataSupport, List<Field> list, List<Field> list2) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.values.clear();
        this.beforeSave(dataSupport, list, this.values);
        long l2 = this.saving(dataSupport, this.values);
        this.afterSave(dataSupport, list, list2, l2);
    }

    private void beforeSave(DataSupport dataSupport, List<Field> list, ContentValues contentValues) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.putFieldsValue(dataSupport, list, contentValues);
        if (!this.ignoreAssociations) {
            this.putForeignKeyValue(contentValues, dataSupport);
        }
    }

    private long saving(DataSupport dataSupport, ContentValues contentValues) {
        if (contentValues.size() == 0) {
            contentValues.putNull("id");
        }
        return this.mDatabase.insert(dataSupport.getTableName(), null, contentValues);
    }

    private void afterSave(DataSupport dataSupport, List<Field> list, List<Field> list2, long l2) throws IllegalAccessException, InvocationTargetException {
        this.throwIfSaveFailed(l2);
        this.assignIdValue(dataSupport, this.getIdField(list), l2);
        this.updateGenericTables(dataSupport, list2, l2);
        if (!this.ignoreAssociations) {
            this.updateAssociatedTableWithFK(dataSupport);
            this.insertIntermediateJoinTableValue(dataSupport, false);
        }
    }

    private void doUpdateAction(DataSupport dataSupport, List<Field> list, List<Field> list2) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.values.clear();
        this.beforeUpdate(dataSupport, list, this.values);
        this.updating(dataSupport, this.values);
        this.afterUpdate(dataSupport, list2);
    }

    private void beforeUpdate(DataSupport dataSupport, List<Field> list, ContentValues contentValues) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.putFieldsValue(dataSupport, list, contentValues);
        if (!this.ignoreAssociations) {
            this.putForeignKeyValue(contentValues, dataSupport);
            for (String string2 : dataSupport.getListToClearSelfFK()) {
                contentValues.putNull(string2);
            }
        }
    }

    private void updating(DataSupport dataSupport, ContentValues contentValues) {
        this.mDatabase.update(dataSupport.getTableName(), contentValues, "id = ?", new String[]{String.valueOf(dataSupport.getBaseObjId())});
    }

    private void afterUpdate(DataSupport dataSupport, List<Field> list) throws InvocationTargetException, IllegalAccessException {
        this.updateGenericTables(dataSupport, list, dataSupport.getBaseObjId());
        if (!this.ignoreAssociations) {
            this.updateAssociatedTableWithFK(dataSupport);
            this.insertIntermediateJoinTableValue(dataSupport, true);
            this.clearFKValueInAssociatedTable(dataSupport);
        }
    }

    private Field getIdField(List<Field> list) {
        for (Field field : list) {
            if (!this.isIdColumn(field.getName())) continue;
            return field;
        }
        return null;
    }

    private void throwIfSaveFailed(long l2) {
        if (l2 == -1L) {
            throw new DataSupportException("Save current model failed.");
        }
    }

    private void assignIdValue(DataSupport dataSupport, Field field, long l2) {
        try {
            this.giveBaseObjIdValue(dataSupport, l2);
            if (field != null) {
                this.giveModelIdValue(dataSupport, field.getName(), field.getType(), l2);
            }
        }
        catch (Exception exception) {
            throw new DataSupportException(exception.getMessage(), exception);
        }
    }

    private void giveModelIdValue(DataSupport dataSupport, String string2, Class<?> clazz, long l2) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (this.shouldGiveModelIdValue(string2, clazz, l2)) {
            Number number;
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                number = (int)l2;
            } else if (clazz == Long.TYPE || clazz == Long.class) {
                number = l2;
            } else {
                throw new DataSupportException("id type is not supported. Only int or long is acceptable for id");
            }
            DynamicExecutor.setField(dataSupport, string2, number, dataSupport.getClass());
        }
    }

    private void putForeignKeyValue(ContentValues contentValues, DataSupport dataSupport) {
        Map<String, Long> map = dataSupport.getAssociatedModelsMapWithoutFK();
        for (String string2 : map.keySet()) {
            contentValues.put(this.getForeignKeyColumnName(string2), map.get(string2));
        }
    }

    private void updateAssociatedTableWithFK(DataSupport dataSupport) {
        Map<String, Set<Long>> map = dataSupport.getAssociatedModelsMapWithFK();
        ContentValues contentValues = new ContentValues();
        for (String string2 : map.keySet()) {
            contentValues.clear();
            String string3 = this.getForeignKeyColumnName(dataSupport.getTableName());
            contentValues.put(string3, Long.valueOf(dataSupport.getBaseObjId()));
            Set<Long> set = map.get(string2);
            if (set == null || set.isEmpty()) continue;
            this.mDatabase.update(string2, contentValues, this.getWhereOfIdsWithOr(set), null);
        }
    }

    private void clearFKValueInAssociatedTable(DataSupport dataSupport) {
        List<String> list = dataSupport.getListToClearAssociatedFK();
        for (String string2 : list) {
            String string3 = this.getForeignKeyColumnName(dataSupport.getTableName());
            ContentValues contentValues = new ContentValues();
            contentValues.putNull(string3);
            String string4 = string3 + " = " + dataSupport.getBaseObjId();
            this.mDatabase.update(string2, contentValues, string4, null);
        }
    }

    private void insertIntermediateJoinTableValue(DataSupport dataSupport, boolean bl2) {
        Map<String, Set<Long>> map = dataSupport.getAssociatedModelsMapForJoinTable();
        ContentValues contentValues = new ContentValues();
        for (String string2 : map.keySet()) {
            String string3 = this.getIntermediateTableName(dataSupport, string2);
            if (bl2) {
                this.mDatabase.delete(string3, this.getWhereForJoinTableToDelete(dataSupport), new String[]{String.valueOf(dataSupport.getBaseObjId())});
            }
            Set<Long> set = map.get(string2);
            for (long l2 : set) {
                contentValues.clear();
                contentValues.put(this.getForeignKeyColumnName(dataSupport.getTableName()), Long.valueOf(dataSupport.getBaseObjId()));
                contentValues.put(this.getForeignKeyColumnName(string2), Long.valueOf(l2));
                this.mDatabase.insert(string3, null, contentValues);
            }
        }
    }

    private String getWhereForJoinTableToDelete(DataSupport dataSupport) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getForeignKeyColumnName(dataSupport.getTableName()));
        stringBuilder.append(" = ?");
        return stringBuilder.toString();
    }

    private boolean shouldGiveModelIdValue(String string2, Class<?> clazz, long l2) {
        return string2 != null && clazz != null && l2 > 0L;
    }

    private void updateGenericTables(DataSupport dataSupport, List<Field> list, long l2) throws IllegalAccessException, InvocationTargetException {
        for (Field field : list) {
            Encrypt encrypt = field.getAnnotation(Encrypt.class);
            String string2 = null;
            if (encrypt != null && "java.lang.String".equals(this.getGenericTypeName(field))) {
                string2 = encrypt.algorithm();
            }
            field.setAccessible(true);
            Collection collection = (Collection)field.get(dataSupport);
            if (collection == null) continue;
            String string3 = DBUtility.getGenericTableName(dataSupport.getClassName(), field.getName());
            String string4 = DBUtility.getGenericValueIdColumnName(dataSupport.getClassName());
            this.mDatabase.delete(string3, string4 + " = ?", new String[]{String.valueOf(l2)});
            for (Object object : collection) {
                ContentValues contentValues = new ContentValues();
                contentValues.put(string4, Long.valueOf(l2));
                object = this.encryptValue(string2, object);
                Object[] objectArray = new Object[]{BaseUtility.changeCase(DBUtility.convertToValidColumnName(field.getName())), object};
                Class[] classArray = new Class[]{String.class, this.getGenericTypeClass(field)};
                DynamicExecutor.send(contentValues, "put", objectArray, contentValues.getClass(), classArray);
                this.mDatabase.insert(string3, null, contentValues);
            }
        }
    }
}

