/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.crud;

import com.komect.network.litepal.crud.AssociationsAnalyzer;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.util.DBUtility;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;

class Many2OneAnalyzer
extends AssociationsAnalyzer {
    Many2OneAnalyzer() {
    }

    void analyze(DataSupport dataSupport, AssociationsInfo associationsInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (dataSupport.getClassName().equals(associationsInfo.getClassHoldsForeignKey())) {
            this.analyzeManySide(dataSupport, associationsInfo);
        } else {
            this.analyzeOneSide(dataSupport, associationsInfo);
        }
    }

    private void analyzeManySide(DataSupport dataSupport, AssociationsInfo associationsInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        DataSupport dataSupport2 = this.getAssociatedModel(dataSupport, associationsInfo);
        if (dataSupport2 != null) {
            Collection<DataSupport> collection = this.getReverseAssociatedModels(dataSupport2, associationsInfo);
            Collection<DataSupport> collection2 = this.checkAssociatedModelCollection(collection, associationsInfo.getAssociateSelfFromOtherModel());
            this.setReverseAssociatedModels(dataSupport2, associationsInfo, collection2);
            this.dealAssociatedModelOnManySide(collection2, dataSupport, dataSupport2);
        } else {
            this.mightClearFKValue(dataSupport, associationsInfo);
        }
    }

    private void analyzeOneSide(DataSupport dataSupport, AssociationsInfo associationsInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Collection<DataSupport> collection = this.getAssociatedModels(dataSupport, associationsInfo);
        if (collection == null || collection.isEmpty()) {
            String string2 = DBUtility.getTableNameByClassName(associationsInfo.getAssociatedClassName());
            dataSupport.addAssociatedTableNameToClearFK(string2);
            return;
        }
        for (DataSupport dataSupport2 : collection) {
            this.buildBidirectionalAssociations(dataSupport, dataSupport2, associationsInfo);
            this.dealAssociatedModelOnOneSide(dataSupport, dataSupport2);
        }
    }

    private void dealAssociatedModelOnManySide(Collection<DataSupport> collection, DataSupport dataSupport, DataSupport dataSupport2) {
        if (!collection.contains(dataSupport)) {
            collection.add(dataSupport);
        }
        if (dataSupport2.isSaved()) {
            dataSupport.addAssociatedModelWithoutFK(dataSupport2.getTableName(), dataSupport2.getBaseObjId());
        }
    }

    private void dealAssociatedModelOnOneSide(DataSupport dataSupport, DataSupport dataSupport2) {
        this.dealsAssociationsOnTheSideWithoutFK(dataSupport, dataSupport2);
    }
}

