/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.crud;

import android.database.sqlite.SQLiteDatabase;
import com.komect.network.litepal.crud.DataHandler;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.exceptions.DataSupportException;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DeleteHandler
extends DataHandler {
    private List<String> foreignKeyTableToDelete;

    DeleteHandler(SQLiteDatabase sQLiteDatabase) {
        this.mDatabase = sQLiteDatabase;
    }

    int onDelete(DataSupport dataSupport) {
        if (dataSupport.isSaved()) {
            List<Field> list = this.getSupportedGenericFields(dataSupport.getClassName());
            this.deleteGenericData(dataSupport.getClass(), list, dataSupport.getBaseObjId());
            Collection<AssociationsInfo> collection = this.analyzeAssociations(dataSupport);
            int n2 = this.deleteCascade(dataSupport);
            this.clearAssociatedModelSaveState(dataSupport, collection);
            return n2 += this.mDatabase.delete(dataSupport.getTableName(), "id = " + dataSupport.getBaseObjId(), null);
        }
        return 0;
    }

    int onDelete(Class<?> clazz, long l2) {
        List<Field> list = this.getSupportedGenericFields(clazz.getName());
        this.deleteGenericData(clazz, list, l2);
        this.analyzeAssociations(clazz);
        int n2 = this.deleteCascade(clazz, l2);
        this.getForeignKeyTableToDelete().clear();
        return n2 += this.mDatabase.delete(this.getTableName(clazz), "id = " + l2, null);
    }

    int onDeleteAll(String string2, String ... stringArray) {
        BaseUtility.checkConditionsCorrect(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            stringArray[0] = DBUtility.convertWhereClauseToColumnName(stringArray[0]);
        }
        return this.mDatabase.delete(string2, this.getWhereClause(stringArray), this.getWhereArgs(stringArray));
    }

    int onDeleteAll(Class<?> clazz, String ... stringArray) {
        List<?> list;
        List<Field> list2;
        BaseUtility.checkConditionsCorrect(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            stringArray[0] = DBUtility.convertWhereClauseToColumnName(stringArray[0]);
        }
        if (!(list2 = this.getSupportedGenericFields(clazz.getName())).isEmpty() && (list = DataSupport.select("id").where(stringArray).find(clazz)).size() > 0) {
            long[] lArray = new long[list.size()];
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                DataSupport dataSupport = (DataSupport)list.get(i2);
                lArray[i2] = dataSupport.getBaseObjId();
            }
            this.deleteGenericData(clazz, list2, lArray);
        }
        this.analyzeAssociations(clazz);
        int n2 = this.deleteAllCascade(clazz, stringArray);
        this.getForeignKeyTableToDelete().clear();
        return n2 += this.mDatabase.delete(this.getTableName(clazz), this.getWhereClause(stringArray), this.getWhereArgs(stringArray));
    }

    private void analyzeAssociations(Class<?> clazz) {
        Collection<AssociationsInfo> collection = this.getAssociationInfo(clazz.getName());
        for (AssociationsInfo associationsInfo : collection) {
            String string2;
            String string3 = DBUtility.getTableNameByClassName(associationsInfo.getAssociatedClassName());
            if (associationsInfo.getAssociationType() == 2 || associationsInfo.getAssociationType() == 1) {
                string2 = associationsInfo.getClassHoldsForeignKey();
                if (clazz.getName().equals(string2)) continue;
                this.getForeignKeyTableToDelete().add(string3);
                continue;
            }
            if (associationsInfo.getAssociationType() != 3) continue;
            string2 = DBUtility.getIntermediateTableName(this.getTableName(clazz), string3);
            string2 = BaseUtility.changeCase(string2);
            this.getForeignKeyTableToDelete().add(string2);
        }
    }

    private int deleteCascade(Class<?> clazz, long l2) {
        int n2 = 0;
        for (String string2 : this.getForeignKeyTableToDelete()) {
            String string3 = this.getForeignKeyColumnName(this.getTableName(clazz));
            n2 += this.mDatabase.delete(string2, string3 + " = " + l2, null);
        }
        return n2;
    }

    private int deleteAllCascade(Class<?> clazz, String ... stringArray) {
        int n2 = 0;
        for (String string2 : this.getForeignKeyTableToDelete()) {
            String string3 = this.getTableName(clazz);
            String string4 = this.getForeignKeyColumnName(string3);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string4).append(" in (select id from ");
            stringBuilder.append(string3);
            if (stringArray != null && stringArray.length > 0) {
                stringBuilder.append(" where ").append(this.buildConditionString(stringArray));
            }
            stringBuilder.append(")");
            n2 += this.mDatabase.delete(string2, BaseUtility.changeCase(stringBuilder.toString()), null);
        }
        return n2;
    }

    private String buildConditionString(String ... stringArray) {
        int n2 = stringArray.length - 1;
        String string2 = stringArray[0];
        for (int i2 = 0; i2 < n2; ++i2) {
            string2 = string2.replaceFirst("\\?", "'" + stringArray[i2 + 1] + "'");
        }
        return string2;
    }

    private Collection<AssociationsInfo> analyzeAssociations(DataSupport dataSupport) {
        try {
            Collection<AssociationsInfo> collection = this.getAssociationInfo(dataSupport.getClassName());
            this.analyzeAssociatedModels(dataSupport, collection);
            return collection;
        }
        catch (Exception exception) {
            throw new DataSupportException(exception.getMessage(), exception);
        }
    }

    private void clearAssociatedModelSaveState(DataSupport dataSupport, Collection<AssociationsInfo> collection) {
        try {
            for (AssociationsInfo associationsInfo : collection) {
                Collection<DataSupport> collection2;
                if (associationsInfo.getAssociationType() == 2 && !dataSupport.getClassName().equals(associationsInfo.getClassHoldsForeignKey())) {
                    collection2 = this.getAssociatedModels(dataSupport, associationsInfo);
                    if (collection2 == null || collection2.isEmpty()) continue;
                    for (DataSupport dataSupport2 : collection2) {
                        if (dataSupport2 == null) continue;
                        dataSupport2.clearSavedState();
                    }
                    continue;
                }
                if (associationsInfo.getAssociationType() != 1 || (collection2 = this.getAssociatedModel(dataSupport, associationsInfo)) == null) continue;
                ((DataSupport)((Object)collection2)).clearSavedState();
            }
        }
        catch (Exception exception) {
            throw new DataSupportException(exception.getMessage(), exception);
        }
    }

    private int deleteCascade(DataSupport dataSupport) {
        int n2 = this.deleteAssociatedForeignKeyRows(dataSupport);
        return n2 += this.deleteAssociatedJoinTableRows(dataSupport);
    }

    private int deleteAssociatedForeignKeyRows(DataSupport dataSupport) {
        int n2 = 0;
        Map<String, Set<Long>> map = dataSupport.getAssociatedModelsMapWithFK();
        for (String string2 : map.keySet()) {
            String string3 = this.getForeignKeyColumnName(dataSupport.getTableName());
            n2 += this.mDatabase.delete(string2, string3 + " = " + dataSupport.getBaseObjId(), null);
        }
        return n2;
    }

    private int deleteAssociatedJoinTableRows(DataSupport dataSupport) {
        int n2 = 0;
        Set<String> set = dataSupport.getAssociatedModelsMapForJoinTable().keySet();
        for (String string2 : set) {
            String string3 = DBUtility.getIntermediateTableName(dataSupport.getTableName(), string2);
            String string4 = this.getForeignKeyColumnName(dataSupport.getTableName());
            n2 += this.mDatabase.delete(string3, string4 + " = " + dataSupport.getBaseObjId(), null);
        }
        return n2;
    }

    private List<String> getForeignKeyTableToDelete() {
        if (this.foreignKeyTableToDelete == null) {
            this.foreignKeyTableToDelete = new ArrayList<String>();
        }
        return this.foreignKeyTableToDelete;
    }

    private void deleteGenericData(Class<?> clazz, List<Field> list, long ... lArray) {
        for (Field field : list) {
            String string2 = DBUtility.getGenericTableName(clazz.getName(), field.getName());
            String string3 = DBUtility.getGenericValueIdColumnName(clazz.getName());
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            for (long l2 : lArray) {
                if (bl2) {
                    stringBuilder.append(" or ");
                }
                stringBuilder.append(string3).append(" = ").append(l2);
                bl2 = true;
            }
            this.mDatabase.delete(string2, stringBuilder.toString(), null);
        }
    }
}

