/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.crud;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.SparseArray;
import com.komect.network.litepal.LitePalBase;
import com.komect.network.litepal.annotation.Encrypt;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.crud.DynamicExecutor;
import com.komect.network.litepal.crud.Many2ManyAnalyzer;
import com.komect.network.litepal.crud.Many2OneAnalyzer;
import com.komect.network.litepal.crud.One2OneAnalyzer;
import com.komect.network.litepal.crud.SaveHandler;
import com.komect.network.litepal.crud.UpdateHandler;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.exceptions.DataSupportException;
import com.komect.network.litepal.exceptions.DatabaseGenerateException;
import com.komect.network.litepal.tablemanager.model.GenericModel;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import com.komect.network.litepal.util.cipher.CipherUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

abstract class DataHandler
extends LitePalBase {
    public static final String TAG = "DataHandler";
    SQLiteDatabase mDatabase;
    private DataSupport tempEmptyModel;
    private List<AssociationsInfo> fkInCurrentModel;
    private List<AssociationsInfo> fkInOtherModel;

    DataHandler() {
    }

    protected <T> List<T> query(Class<T> clazz, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6, List<AssociationsInfo> list) {
        SparseArray sparseArray = new ArrayList();
        try (Cursor cursor = null;){
            SparseArray sparseArray2;
            List<Field> list2 = this.getSupportedFields(clazz.getName());
            List<Field> list3 = this.getSupportedGenericFields(clazz.getName());
            String[] stringArray3 = DBUtility.convertSelectClauseToValidNames(this.getCustomizedColumns(stringArray, list3, list));
            String string7 = this.getTableName(clazz);
            cursor = this.mDatabase.query(string7, stringArray3, string2, stringArray2, string3, string4, string5, string6);
            if (cursor.moveToFirst()) {
                sparseArray2 = new SparseArray();
                HashMap<Field, GenericModel> hashMap = new HashMap<Field, GenericModel>();
                do {
                    Object object = this.createInstanceFromClass(clazz);
                    this.giveBaseObjIdValue((DataSupport)object, cursor.getLong(cursor.getColumnIndexOrThrow("id")));
                    this.setValueToModel(object, list2, list, cursor, (SparseArray<QueryInfoCache>)sparseArray2);
                    this.setGenericValueToModel((DataSupport)object, list3, hashMap);
                    if (list != null) {
                        this.setAssociatedModel((DataSupport)object);
                    }
                    sparseArray.add(object);
                } while (cursor.moveToNext());
                sparseArray2.clear();
                hashMap.clear();
            }
            sparseArray2 = sparseArray;
            return sparseArray2;
        }
    }

    protected <T> T mathQuery(String string2, String[] stringArray, String[] stringArray2, Class<T> clazz) {
        BaseUtility.checkConditionsCorrect(stringArray2);
        Object object = null;
        try (Cursor cursor = null;){
            cursor = this.mDatabase.query(string2, stringArray, this.getWhereClause(stringArray2), this.getWhereArgs(stringArray2), null, null, null);
            if (cursor.moveToFirst()) {
                Class<?> clazz2 = cursor.getClass();
                Method method = clazz2.getMethod(this.genGetColumnMethod(clazz), Integer.TYPE);
                object = method.invoke((Object)cursor, 0);
            }
        }
        return (T)object;
    }

    protected void giveBaseObjIdValue(DataSupport dataSupport, long l2) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (l2 > 0L) {
            DynamicExecutor.set(dataSupport, "baseObjId", l2, DataSupport.class);
        }
    }

    protected void putFieldsValue(DataSupport dataSupport, List<Field> list, ContentValues contentValues) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (Field field : list) {
            if (this.isIdColumn(field.getName())) continue;
            this.putFieldsValueDependsOnSaveOrUpdate(dataSupport, field, contentValues);
        }
    }

    protected void putContentValuesForSave(DataSupport dataSupport, Field field, ContentValues contentValues) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object object = DynamicExecutor.getField(dataSupport, field.getName(), dataSupport.getClass());
        if (object != null) {
            Object object2;
            if ("java.util.Date".equals(field.getType().getName())) {
                object2 = (Date)object;
                object = ((Date)object2).getTime();
            }
            if ((object2 = field.getAnnotation(Encrypt.class)) != null && "java.lang.String".equals(field.getType().getName())) {
                object = this.encryptValue(object2.algorithm(), object);
            }
            Object[] objectArray = new Object[]{BaseUtility.changeCase(DBUtility.convertToValidColumnName(field.getName())), object};
            Class<?>[] classArray = this.getParameterTypes(field, object, objectArray);
            DynamicExecutor.send(contentValues, "put", objectArray, contentValues.getClass(), classArray);
        }
    }

    protected void putContentValuesForUpdate(DataSupport dataSupport, Field field, ContentValues contentValues) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object object;
        Object object2 = this.getFieldValue(dataSupport, field);
        if ("java.util.Date".equals(field.getType().getName()) && object2 != null) {
            object = (Date)object2;
            object2 = ((Date)object).getTime();
        }
        if ((object = field.getAnnotation(Encrypt.class)) != null && "java.lang.String".equals(field.getType().getName())) {
            object2 = this.encryptValue(object.algorithm(), object2);
        }
        Object[] objectArray = new Object[]{BaseUtility.changeCase(DBUtility.convertToValidColumnName(field.getName())), object2};
        Class<?>[] classArray = this.getParameterTypes(field, object2, objectArray);
        DynamicExecutor.send(contentValues, "put", objectArray, contentValues.getClass(), classArray);
    }

    protected Object encryptValue(String string2, Object object) {
        if (string2 != null && object != null) {
            if ("AES".equalsIgnoreCase(string2)) {
                object = CipherUtil.aesEncrypt((String)object);
            } else if ("MD5".equalsIgnoreCase(string2)) {
                object = CipherUtil.md5Encrypt((String)object);
            }
        }
        return object;
    }

    protected Object getFieldValue(DataSupport dataSupport, Field field) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.shouldGetOrSet(dataSupport, field)) {
            return DynamicExecutor.getField(dataSupport, field.getName(), dataSupport.getClass());
        }
        return null;
    }

    protected void setFieldValue(DataSupport dataSupport, Field field, Object object) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.shouldGetOrSet(dataSupport, field)) {
            DynamicExecutor.setField(dataSupport, field.getName(), object, dataSupport.getClass());
        }
    }

    protected void analyzeAssociatedModels(DataSupport dataSupport, Collection<AssociationsInfo> collection) {
        try {
            for (AssociationsInfo associationsInfo : collection) {
                if (associationsInfo.getAssociationType() == 2) {
                    new Many2OneAnalyzer().analyze(dataSupport, associationsInfo);
                    continue;
                }
                if (associationsInfo.getAssociationType() == 1) {
                    new One2OneAnalyzer().analyze(dataSupport, associationsInfo);
                    continue;
                }
                if (associationsInfo.getAssociationType() != 3) continue;
                new Many2ManyAnalyzer().analyze(dataSupport, associationsInfo);
            }
        }
        catch (Exception exception) {
            throw new DataSupportException(exception.getMessage(), exception);
        }
    }

    protected DataSupport getAssociatedModel(DataSupport dataSupport, AssociationsInfo associationsInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (DataSupport)this.getFieldValue(dataSupport, associationsInfo.getAssociateOtherModelFromSelf());
    }

    protected Collection<DataSupport> getAssociatedModels(DataSupport dataSupport, AssociationsInfo associationsInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (Collection)this.getFieldValue(dataSupport, associationsInfo.getAssociateOtherModelFromSelf());
    }

    protected DataSupport getEmptyModel(DataSupport dataSupport) {
        if (this.tempEmptyModel != null) {
            return this.tempEmptyModel;
        }
        String string2 = null;
        try {
            string2 = dataSupport.getClassName();
            Class<?> clazz = Class.forName(string2);
            this.tempEmptyModel = (DataSupport)clazz.newInstance();
            return this.tempEmptyModel;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DatabaseGenerateException("can not find a class named " + string2);
        }
        catch (InstantiationException instantiationException) {
            throw new DataSupportException(string2 + " needs a default constructor.", instantiationException);
        }
        catch (Exception exception) {
            throw new DataSupportException(exception.getMessage(), exception);
        }
    }

    protected String getWhereClause(String ... stringArray) {
        if (this.isAffectAllLines(new Object[]{stringArray})) {
            return null;
        }
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    protected String[] getWhereArgs(String ... stringArray) {
        if (this.isAffectAllLines(new Object[]{stringArray})) {
            return null;
        }
        if (stringArray != null && stringArray.length > 1) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
            return stringArray2;
        }
        return null;
    }

    protected boolean isAffectAllLines(Object ... objectArray) {
        return objectArray != null && objectArray.length == 0;
    }

    protected String getWhereOfIdsWithOr(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (long l2 : collection) {
            if (bl2) {
                stringBuilder.append(" or ");
            }
            bl2 = true;
            stringBuilder.append("id = ");
            stringBuilder.append(l2);
        }
        return BaseUtility.changeCase(stringBuilder.toString());
    }

    protected String getWhereOfIdsWithOr(long ... lArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (long l2 : lArray) {
            if (bl2) {
                stringBuilder.append(" or ");
            }
            bl2 = true;
            stringBuilder.append("id = ");
            stringBuilder.append(l2);
        }
        return BaseUtility.changeCase(stringBuilder.toString());
    }

    protected boolean shouldGetOrSet(DataSupport dataSupport, Field field) {
        return dataSupport != null && field != null;
    }

    protected String getIntermediateTableName(DataSupport dataSupport, String string2) {
        return BaseUtility.changeCase(DBUtility.getIntermediateTableName(dataSupport.getTableName(), string2));
    }

    protected String getTableName(Class<?> clazz) {
        return BaseUtility.changeCase(DBUtility.getTableNameByClassName(clazz.getName()));
    }

    protected Object createInstanceFromClass(Class<?> clazz) {
        try {
            Constructor<?> constructor = this.findBestSuitConstructor(clazz);
            return constructor.newInstance(this.getConstructorParams(clazz, constructor));
        }
        catch (Exception exception) {
            throw new DataSupportException(exception.getMessage(), exception);
        }
    }

    protected Constructor<?> findBestSuitConstructor(Class<?> clazz) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        SparseArray sparseArray = new SparseArray();
        int n2 = Integer.MAX_VALUE;
        for (Constructor<?> constructor : constructorArray) {
            Class<?>[] classArray;
            int n3 = constructor.getParameterTypes().length;
            for (Class<?> clazz2 : classArray = constructor.getParameterTypes()) {
                if (clazz2 == clazz) {
                    n3 += 10000;
                    continue;
                }
                if (!clazz2.getName().equals("com.android.tools.fd.runtime.InstantReloadException")) continue;
                n3 += 10000;
            }
            if (sparseArray.get(n3) == null) {
                sparseArray.put(n3, constructor);
            }
            if (n3 >= n2) continue;
            n2 = n3;
        }
        Constructor constructor = (Constructor)sparseArray.get(n2);
        if (constructor != null) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    protected Object[] getConstructorParams(Class<?> clazz, Constructor<?> constructor) {
        Class<?>[] classArray = constructor.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            objectArray[i2] = this.getInitParamValue(clazz, classArray[i2]);
        }
        return objectArray;
    }

    protected void setValueToModel(Object object, List<Field> list, List<AssociationsInfo> list2, Cursor cursor, SparseArray<QueryInfoCache> sparseArray) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object object2;
        int n2 = sparseArray.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = sparseArray.keyAt(i2);
                object2 = (QueryInfoCache)sparseArray.get(n3);
                this.setToModelByReflection(object, ((QueryInfoCache)object2).field, n3, ((QueryInfoCache)object2).getMethodName, cursor);
            }
        } else {
            for (Field field : list) {
                object2 = this.genGetColumnMethod(field);
                String string2 = this.isIdColumn(field.getName()) ? "id" : DBUtility.convertToValidColumnName(field.getName());
                int n4 = cursor.getColumnIndex(BaseUtility.changeCase(string2));
                if (n4 == -1) continue;
                this.setToModelByReflection(object, field, n4, (String)object2, cursor);
                QueryInfoCache queryInfoCache = new QueryInfoCache();
                queryInfoCache.getMethodName = object2;
                queryInfoCache.field = field;
                sparseArray.put(n4, (Object)queryInfoCache);
            }
        }
        if (list2 != null) {
            for (AssociationsInfo associationsInfo : list2) {
                object2 = this.getForeignKeyColumnName(DBUtility.getTableNameByClassName(associationsInfo.getAssociatedClassName()));
                int n5 = cursor.getColumnIndex((String)object2);
                if (n5 == -1) continue;
                long l2 = cursor.getLong(n5);
                try {
                    DataSupport dataSupport = (DataSupport)DataSupport.find(Class.forName(associationsInfo.getAssociatedClassName()), l2);
                    if (dataSupport == null) continue;
                    this.setFieldValue((DataSupport)object, associationsInfo.getAssociateOtherModelFromSelf(), dataSupport);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGenericValueToModel(DataSupport dataSupport, List<Field> list, Map<Field, GenericModel> map) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (Field field : list) {
            String string2;
            String string3;
            String string4;
            String string5;
            Cursor cursor = null;
            GenericModel genericModel = map.get(field);
            if (genericModel == null) {
                string5 = DBUtility.getGenericTableName(dataSupport.getClassName(), field.getName());
                string4 = DBUtility.convertToValidColumnName(field.getName());
                string3 = DBUtility.getGenericValueIdColumnName(dataSupport.getClassName());
                string2 = this.genGetColumnMethod(field);
                GenericModel genericModel2 = new GenericModel();
                genericModel2.setTableName(string5);
                genericModel2.setValueColumnName(string4);
                genericModel2.setValueIdColumnName(string3);
                genericModel2.setGetMethodName(string2);
                map.put(field, genericModel2);
            } else {
                string5 = genericModel.getTableName();
                string4 = genericModel.getValueColumnName();
                string3 = genericModel.getValueIdColumnName();
                string2 = genericModel.getGetMethodName();
            }
            try {
                cursor = this.mDatabase.query(string5, null, string3 + " = ?", new String[]{String.valueOf(dataSupport.getBaseObjId())}, null, null, null);
                if (!cursor.moveToFirst()) continue;
                do {
                    int n2;
                    if ((n2 = cursor.getColumnIndex(BaseUtility.changeCase(string4))) == -1) continue;
                    this.setToModelByReflection(dataSupport, field, n2, string2, cursor);
                } while (cursor.moveToNext());
            }
            finally {
                if (cursor == null) continue;
                cursor.close();
            }
        }
    }

    protected List<AssociationsInfo> getForeignKeyAssociations(String string2, boolean bl2) {
        if (bl2) {
            this.analyzeAssociations(string2);
            return this.fkInCurrentModel;
        }
        return null;
    }

    protected Class<?>[] getParameterTypes(Field field, Object object, Object[] objectArray) {
        Class[] classArray;
        if (this.isCharType(field)) {
            objectArray[1] = String.valueOf(object);
            classArray = new Class[]{String.class, String.class};
        } else {
            classArray = field.getType().isPrimitive() ? new Class[]{String.class, this.getObjectType(field.getType())} : ("java.util.Date".equals(field.getType().getName()) ? new Class[]{String.class, Long.class} : new Class[]{String.class, field.getType()});
        }
        return classArray;
    }

    private Class<?> getObjectType(Class<?> clazz) {
        if (clazz != null && clazz.isPrimitive()) {
            String string2 = clazz.getName();
            if ("int".equals(string2)) {
                return Integer.class;
            }
            if ("short".equals(string2)) {
                return Short.class;
            }
            if ("long".equals(string2)) {
                return Long.class;
            }
            if ("float".equals(string2)) {
                return Float.class;
            }
            if ("double".equals(string2)) {
                return Double.class;
            }
            if ("boolean".equals(string2)) {
                return Boolean.class;
            }
            if ("char".equals(string2)) {
                return Character.class;
            }
        }
        return null;
    }

    private Object getInitParamValue(Class<?> clazz, Class<?> clazz2) {
        String string2 = clazz2.getName();
        if ("boolean".equals(string2) || "java.lang.Boolean".equals(string2)) {
            return false;
        }
        if ("float".equals(string2) || "java.lang.Float".equals(string2)) {
            return Float.valueOf(0.0f);
        }
        if ("double".equals(string2) || "java.lang.Double".equals(string2)) {
            return 0.0;
        }
        if ("int".equals(string2) || "java.lang.Integer".equals(string2)) {
            return 0;
        }
        if ("long".equals(string2) || "java.lang.Long".equals(string2)) {
            return 0L;
        }
        if ("short".equals(string2) || "java.lang.Short".equals(string2)) {
            return 0;
        }
        if ("char".equals(string2) || "java.lang.Character".equals(string2)) {
            return Character.valueOf(' ');
        }
        if ("[B".equals(string2) || "[Ljava.lang.Byte;".equals(string2)) {
            return new byte[0];
        }
        if ("java.lang.String".equals(string2)) {
            return "";
        }
        if (clazz == clazz2) {
            return null;
        }
        return this.createInstanceFromClass(clazz2);
    }

    private boolean isCharType(Field field) {
        String string2 = field.getType().getName();
        return string2.equals("char") || string2.endsWith("Character");
    }

    private boolean isPrimitiveBooleanType(Field field) {
        Class<?> clazz = field.getType();
        return "boolean".equals(clazz.getName());
    }

    private void putFieldsValueDependsOnSaveOrUpdate(DataSupport dataSupport, Field field, ContentValues contentValues) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.isUpdating()) {
            if (!this.isFieldWithDefaultValue(dataSupport, field)) {
                this.putContentValuesForUpdate(dataSupport, field, contentValues);
            }
        } else if (this.isSaving()) {
            this.putContentValuesForSave(dataSupport, field, contentValues);
        }
    }

    private boolean isUpdating() {
        return UpdateHandler.class.getName().equals(this.getClass().getName());
    }

    private boolean isSaving() {
        return SaveHandler.class.getName().equals(this.getClass().getName());
    }

    private boolean isFieldWithDefaultValue(DataSupport dataSupport, Field field) throws IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        DataSupport dataSupport2 = this.getEmptyModel(dataSupport);
        Object object = this.getFieldValue(dataSupport, field);
        Object object2 = this.getFieldValue(dataSupport2, field);
        if (object != null && object2 != null) {
            String string2 = object.toString();
            String string3 = object2.toString();
            return string2.equals(string3);
        }
        return object == object2;
    }

    private String makeGetterMethodName(Field field) {
        String string2;
        String string3 = field.getName();
        if (this.isPrimitiveBooleanType(field)) {
            if (string3.matches("^is[A-Z]{1}.*$")) {
                string3 = string3.substring(2);
            }
            string2 = "is";
        } else {
            string2 = "get";
        }
        if (string3.matches("^[a-z]{1}[A-Z]{1}.*")) {
            return string2 + string3;
        }
        return string2 + BaseUtility.capitalize(string3);
    }

    private String makeSetterMethodName(Field field) {
        String string2 = "set";
        String string3 = this.isPrimitiveBooleanType(field) && field.getName().matches("^is[A-Z]{1}.*$") ? string2 + field.getName().substring(2) : (field.getName().matches("^[a-z]{1}[A-Z]{1}.*") ? string2 + field.getName() : string2 + BaseUtility.capitalize(field.getName()));
        return string3;
    }

    private String genGetColumnMethod(Field field) {
        Class<?> clazz = this.isCollection(field.getType()) ? this.getGenericTypeClass(field) : field.getType();
        return this.genGetColumnMethod(clazz);
    }

    private String genGetColumnMethod(Class<?> clazz) {
        String string2 = clazz.isPrimitive() ? BaseUtility.capitalize(clazz.getName()) : clazz.getSimpleName();
        String string3 = "get" + string2;
        if ("getBoolean".equals(string3)) {
            string3 = "getInt";
        } else if ("getChar".equals(string3) || "getCharacter".equals(string3)) {
            string3 = "getString";
        } else if ("getDate".equals(string3)) {
            string3 = "getLong";
        } else if ("getInteger".equals(string3)) {
            string3 = "getInt";
        } else if ("getbyte[]".equalsIgnoreCase(string3)) {
            string3 = "getBlob";
        }
        return string3;
    }

    private String[] getCustomizedColumns(String[] stringArray, List<Field> list, List<AssociationsInfo> list2) {
        if (stringArray != null && stringArray.length > 0) {
            String string2;
            int n2;
            boolean bl2 = false;
            List<String> list3 = Arrays.asList(stringArray);
            ArrayList<String> arrayList = new ArrayList<String>(list3);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            ArrayList<Field> arrayList5 = new ArrayList<Field>();
            for (Field object : list) {
                arrayList2.add(object.getName());
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                String field = (String)arrayList.get(n2);
                if (BaseUtility.containsIgnoreCases(arrayList2, field)) {
                    arrayList3.add(n2);
                    continue;
                }
                if (!this.isIdColumn(field)) continue;
                bl2 = true;
                if (!"_id".equalsIgnoreCase(field)) continue;
                arrayList.set(n2, BaseUtility.changeCase("id"));
            }
            for (n2 = arrayList3.size() - 1; n2 >= 0; --n2) {
                int string3 = (Integer)arrayList3.get(n2);
                string2 = (String)arrayList.remove(string3);
                arrayList4.add(string2);
            }
            for (Field field : list) {
                string2 = field.getName();
                if (!BaseUtility.containsIgnoreCases(arrayList4, string2)) continue;
                arrayList5.add(field);
            }
            list.clear();
            list.addAll(arrayList5);
            if (list2 != null && list2.size() > 0) {
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    String string3 = DBUtility.getTableNameByClassName(list2.get(i2).getAssociatedClassName());
                    arrayList.add(this.getForeignKeyColumnName(string3));
                }
            }
            if (!bl2) {
                arrayList.add(BaseUtility.changeCase("id"));
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    private void analyzeAssociations(String string2) {
        Collection<AssociationsInfo> collection = this.getAssociationInfo(string2);
        if (this.fkInCurrentModel == null) {
            this.fkInCurrentModel = new ArrayList<AssociationsInfo>();
        } else {
            this.fkInCurrentModel.clear();
        }
        if (this.fkInOtherModel == null) {
            this.fkInOtherModel = new ArrayList<AssociationsInfo>();
        } else {
            this.fkInOtherModel.clear();
        }
        for (AssociationsInfo associationsInfo : collection) {
            if (associationsInfo.getAssociationType() == 2 || associationsInfo.getAssociationType() == 1) {
                if (associationsInfo.getClassHoldsForeignKey().equals(string2)) {
                    this.fkInCurrentModel.add(associationsInfo);
                    continue;
                }
                this.fkInOtherModel.add(associationsInfo);
                continue;
            }
            if (associationsInfo.getAssociationType() != 3) continue;
            this.fkInOtherModel.add(associationsInfo);
        }
    }

    private void setAssociatedModel(DataSupport dataSupport) {
        if (this.fkInOtherModel == null) {
            return;
        }
        for (AssociationsInfo associationsInfo : this.fkInOtherModel) {
            Cursor cursor = null;
            String string2 = associationsInfo.getAssociatedClassName();
            boolean bl2 = associationsInfo.getAssociationType() == 3;
            try {
                Object object;
                Object object2;
                Object object3;
                String string3;
                List<Field> list = this.getSupportedFields(string2);
                List<Field> list2 = this.getSupportedGenericFields(string2);
                if (bl2) {
                    string3 = dataSupport.getTableName();
                    object3 = DBUtility.getTableNameByClassName(string2);
                    object2 = DBUtility.getIntermediateTableName(string3, (String)object3);
                    object = new StringBuilder();
                    ((StringBuilder)object).append("select * from ").append((String)object3).append(" a inner join ").append((String)object2).append(" b on a.id = b.").append((String)object3 + "_id").append(" where b.").append(string3).append("_id = ?");
                    cursor = DataSupport.findBySQL(BaseUtility.changeCase(((StringBuilder)object).toString()), String.valueOf(dataSupport.getBaseObjId()));
                } else {
                    string3 = this.getForeignKeyColumnName(DBUtility.getTableNameByClassName(associationsInfo.getSelfClassName()));
                    object3 = DBUtility.getTableNameByClassName(string2);
                    cursor = this.mDatabase.query(BaseUtility.changeCase((String)object3), null, string3 + "=?", new String[]{String.valueOf(dataSupport.getBaseObjId())}, null, null, null, null);
                }
                if (cursor == null || !cursor.moveToFirst()) continue;
                string3 = new SparseArray();
                object3 = new HashMap();
                do {
                    object2 = (DataSupport)this.createInstanceFromClass(Class.forName(string2));
                    this.giveBaseObjIdValue((DataSupport)object2, cursor.getLong(cursor.getColumnIndexOrThrow("id")));
                    this.setValueToModel(object2, list, null, cursor, (SparseArray<QueryInfoCache>)string3);
                    this.setGenericValueToModel((DataSupport)object2, list2, (Map<Field, GenericModel>)object3);
                    if (associationsInfo.getAssociationType() == 2 || bl2) {
                        object = associationsInfo.getAssociateOtherModelFromSelf();
                        AbstractCollection abstractCollection = (ArrayList<Object>)this.getFieldValue(dataSupport, (Field)object);
                        if (abstractCollection == null) {
                            abstractCollection = this.isList(((Field)object).getType()) ? new ArrayList<Object>() : new HashSet();
                            DynamicExecutor.setField(dataSupport, ((Field)object).getName(), abstractCollection, dataSupport.getClass());
                        }
                        abstractCollection.add(object2);
                        continue;
                    }
                    if (associationsInfo.getAssociationType() != 1) continue;
                    this.setFieldValue(dataSupport, associationsInfo.getAssociateOtherModelFromSelf(), object2);
                } while (cursor.moveToNext());
                string3.clear();
                object3.clear();
            }
            catch (Exception exception) {
                throw new DataSupportException(exception.getMessage(), exception);
            }
            finally {
                if (cursor == null) continue;
                cursor.close();
            }
        }
    }

    private void setToModelByReflection(Object object, Field field, int n2, String string2, Cursor cursor) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = cursor.getClass();
        Method method = clazz.getMethod(string2, Integer.TYPE);
        Object object2 = method.invoke((Object)cursor, n2);
        if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
            if ("0".equals(String.valueOf(object2))) {
                object2 = false;
            } else if ("1".equals(String.valueOf(object2))) {
                object2 = true;
            }
        } else if (field.getType() == Character.TYPE || field.getType() == Character.class) {
            object2 = Character.valueOf(((String)object2).charAt(0));
        } else if (field.getType() == Date.class) {
            long l2 = (Long)object2;
            object2 = l2 <= 0L ? null : new Date(l2);
        }
        if (this.isCollection(field.getType())) {
            Encrypt encrypt;
            AbstractCollection abstractCollection = (ArrayList<Object>)DynamicExecutor.getField(object, field.getName(), object.getClass());
            if (abstractCollection == null) {
                abstractCollection = this.isList(field.getType()) ? new ArrayList<Object>() : new HashSet();
                DynamicExecutor.setField(object, field.getName(), abstractCollection, object.getClass());
            }
            if ((encrypt = field.getAnnotation(Encrypt.class)) != null && "java.lang.String".equals(this.getGenericTypeName(field))) {
                object2 = this.decryptValue(encrypt.algorithm(), object2);
            }
            abstractCollection.add(object2);
        } else {
            Encrypt encrypt = field.getAnnotation(Encrypt.class);
            if (encrypt != null && "java.lang.String".equals(field.getType().getName())) {
                object2 = this.decryptValue(encrypt.algorithm(), object2);
            }
            DynamicExecutor.setField(object, field.getName(), object2, object.getClass());
        }
    }

    protected Object decryptValue(String string2, Object object) {
        if (string2 != null && object != null && "AES".equalsIgnoreCase(string2)) {
            object = CipherUtil.aesDecrypt((String)object);
        }
        return object;
    }

    class QueryInfoCache {
        String getMethodName;
        Field field;

        QueryInfoCache() {
        }
    }
}

