/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal;

import com.komect.network.litepal.annotation.Column;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.exceptions.DatabaseGenerateException;
import com.komect.network.litepal.parser.LitePalAttr;
import com.komect.network.litepal.tablemanager.model.AssociationsModel;
import com.komect.network.litepal.tablemanager.model.ColumnModel;
import com.komect.network.litepal.tablemanager.model.GenericModel;
import com.komect.network.litepal.tablemanager.model.TableModel;
import com.komect.network.litepal.tablemanager.typechange.BlobOrm;
import com.komect.network.litepal.tablemanager.typechange.BooleanOrm;
import com.komect.network.litepal.tablemanager.typechange.DateOrm;
import com.komect.network.litepal.tablemanager.typechange.DecimalOrm;
import com.komect.network.litepal.tablemanager.typechange.NumericOrm;
import com.komect.network.litepal.tablemanager.typechange.OrmChange;
import com.komect.network.litepal.tablemanager.typechange.TextOrm;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class LitePalBase {
    public static final String TAG = "LitePalBase";
    private static final int GET_ASSOCIATIONS_ACTION = 1;
    private static final int GET_ASSOCIATION_INFO_ACTION = 2;
    private OrmChange[] typeChangeRules = new OrmChange[]{new NumericOrm(), new TextOrm(), new BooleanOrm(), new DecimalOrm(), new DateOrm(), new BlobOrm()};
    private Map<String, List<Field>> classFieldsMap = new HashMap<String, List<Field>>();
    private Map<String, List<Field>> classGenericFieldsMap = new HashMap<String, List<Field>>();
    private Collection<AssociationsModel> mAssociationModels;
    private Collection<AssociationsInfo> mAssociationInfos;
    private Collection<GenericModel> mGenericModels;

    protected TableModel getTableModel(String string2) {
        String string3 = DBUtility.getTableNameByClassName(string2);
        TableModel tableModel = new TableModel();
        tableModel.setTableName(string3);
        tableModel.setClassName(string2);
        List<Field> list = this.getSupportedFields(string2);
        for (Field field : list) {
            ColumnModel columnModel = this.convertFieldToColumnModel(field);
            tableModel.addColumnModel(columnModel);
        }
        return tableModel;
    }

    protected Collection<AssociationsModel> getAssociations(List<String> list) {
        if (this.mAssociationModels == null) {
            this.mAssociationModels = new HashSet<AssociationsModel>();
        }
        if (this.mGenericModels == null) {
            this.mGenericModels = new HashSet<GenericModel>();
        }
        this.mAssociationModels.clear();
        this.mGenericModels.clear();
        for (String string2 : list) {
            this.analyzeClassFields(string2, 1);
        }
        return this.mAssociationModels;
    }

    protected Collection<GenericModel> getGenericModels() {
        return this.mGenericModels;
    }

    protected Collection<AssociationsInfo> getAssociationInfo(String string2) {
        if (this.mAssociationInfos == null) {
            this.mAssociationInfos = new HashSet<AssociationsInfo>();
        }
        this.mAssociationInfos.clear();
        this.analyzeClassFields(string2, 2);
        return this.mAssociationInfos;
    }

    protected List<Field> getSupportedFields(String string2) {
        List<Field> list = this.classFieldsMap.get(string2);
        if (list == null) {
            Class<?> clazz;
            ArrayList<Field> arrayList = new ArrayList<Field>();
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new DatabaseGenerateException("can not find a class named " + string2);
            }
            this.recursiveSupportedFields(clazz, arrayList);
            this.classFieldsMap.put(string2, arrayList);
            return arrayList;
        }
        return list;
    }

    protected List<Field> getSupportedGenericFields(String string2) {
        List<Field> list = this.classGenericFieldsMap.get(string2);
        if (list == null) {
            Class<?> clazz;
            ArrayList<Field> arrayList = new ArrayList<Field>();
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new DatabaseGenerateException("can not find a class named " + string2);
            }
            this.recursiveSupportedGenericFields(clazz, arrayList);
            this.classGenericFieldsMap.put(string2, arrayList);
            return arrayList;
        }
        return list;
    }

    protected boolean isCollection(Class<?> clazz) {
        return this.isList(clazz) || this.isSet(clazz);
    }

    protected boolean isList(Class<?> clazz) {
        return List.class.isAssignableFrom(clazz);
    }

    protected boolean isSet(Class<?> clazz) {
        return Set.class.isAssignableFrom(clazz);
    }

    protected boolean isIdColumn(String string2) {
        return "_id".equalsIgnoreCase(string2) || "id".equalsIgnoreCase(string2);
    }

    protected String getForeignKeyColumnName(String string2) {
        return BaseUtility.changeCase(string2 + "_id");
    }

    protected String getColumnType(String string2) {
        for (OrmChange ormChange : this.typeChangeRules) {
            String string3 = ormChange.object2Relation(string2);
            if (string3 == null) continue;
            return string3;
        }
        return null;
    }

    protected Class<?> getGenericTypeClass(Field field) {
        Type type = field.getGenericType();
        if (type != null && type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    private void recursiveSupportedFields(Class<?> clazz, List<Field> list) {
        if (clazz == DataSupport.class || clazz == Object.class) {
            return;
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        if (fieldArray != null && fieldArray.length > 0) {
            for (Field field : fieldArray) {
                Class<?> clazz2;
                String string2;
                int n2;
                Column column = field.getAnnotation(Column.class);
                if (column != null && column.ignore() || Modifier.isStatic(n2 = field.getModifiers()) || !BaseUtility.isFieldTypeSupported(string2 = (clazz2 = field.getType()).getName())) continue;
                list.add(field);
            }
        }
        this.recursiveSupportedFields(clazz.getSuperclass(), list);
    }

    private void recursiveSupportedGenericFields(Class<?> clazz, List<Field> list) {
        if (clazz == DataSupport.class || clazz == Object.class) {
            return;
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        if (fieldArray != null && fieldArray.length > 0) {
            for (Field field : fieldArray) {
                String string2;
                int n2;
                Column column = field.getAnnotation(Column.class);
                if (column != null && column.ignore() || Modifier.isStatic(n2 = field.getModifiers()) || !this.isCollection(field.getType()) || !BaseUtility.isGenericTypeSupported(string2 = this.getGenericTypeName(field))) continue;
                list.add(field);
            }
        }
        this.recursiveSupportedGenericFields(clazz.getSuperclass(), list);
    }

    private void analyzeClassFields(String string2, int n2) {
        try {
            Field[] fieldArray;
            Class<?> clazz = Class.forName(string2);
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                Column column;
                if (!this.isNonPrimitive(field) || (column = field.getAnnotation(Column.class)) != null && column.ignore()) continue;
                this.oneToAnyConditions(string2, field, n2);
                this.manyToAnyConditions(string2, field, n2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new DatabaseGenerateException("can not find a class named " + string2);
        }
    }

    private boolean isNonPrimitive(Field field) {
        return !field.getType().isPrimitive();
    }

    private boolean isPrivate(Field field) {
        return Modifier.isPrivate(field.getModifiers());
    }

    private void oneToAnyConditions(String string2, Field field, int n2) throws ClassNotFoundException {
        Class<?> clazz = field.getType();
        if (LitePalAttr.getInstance().getClassNames().contains(clazz.getName())) {
            Class<?> clazz2 = Class.forName(clazz.getName());
            Field[] fieldArray = clazz2.getDeclaredFields();
            boolean bl2 = false;
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                String string3;
                Field field2 = fieldArray[i2];
                if (Modifier.isStatic(field2.getModifiers())) continue;
                Class<?> clazz3 = field2.getType();
                if (string2.equals(clazz3.getName())) {
                    if (n2 == 1) {
                        this.addIntoAssociationModelCollection(string2, clazz.getName(), clazz.getName(), 1);
                    } else if (n2 == 2) {
                        this.addIntoAssociationInfoCollection(string2, clazz.getName(), clazz.getName(), field, field2, 1);
                    }
                    bl2 = true;
                    continue;
                }
                if (!this.isCollection(clazz3) || !string2.equals(string3 = this.getGenericTypeName(field2))) continue;
                if (n2 == 1) {
                    this.addIntoAssociationModelCollection(string2, clazz.getName(), string2, 2);
                } else if (n2 == 2) {
                    this.addIntoAssociationInfoCollection(string2, clazz.getName(), string2, field, field2, 2);
                }
                bl2 = true;
            }
            if (!bl2) {
                if (n2 == 1) {
                    this.addIntoAssociationModelCollection(string2, clazz.getName(), clazz.getName(), 1);
                } else if (n2 == 2) {
                    this.addIntoAssociationInfoCollection(string2, clazz.getName(), clazz.getName(), field, null, 1);
                }
            }
        }
    }

    private void manyToAnyConditions(String string2, Field field, int n2) throws ClassNotFoundException {
        if (this.isCollection(field.getType())) {
            String string3 = this.getGenericTypeName(field);
            if (LitePalAttr.getInstance().getClassNames().contains(string3)) {
                Class<?> clazz = Class.forName(string3);
                Field[] fieldArray = clazz.getDeclaredFields();
                boolean bl2 = false;
                for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                    String string4;
                    Field field2 = fieldArray[i2];
                    if (Modifier.isStatic(field2.getModifiers())) continue;
                    Class<?> clazz2 = field2.getType();
                    if (string2.equals(clazz2.getName())) {
                        if (n2 == 1) {
                            this.addIntoAssociationModelCollection(string2, string3, string3, 2);
                        } else if (n2 == 2) {
                            this.addIntoAssociationInfoCollection(string2, string3, string3, field, field2, 2);
                        }
                        bl2 = true;
                        continue;
                    }
                    if (!this.isCollection(clazz2) || !string2.equals(string4 = this.getGenericTypeName(field2))) continue;
                    if (n2 == 1) {
                        this.addIntoAssociationModelCollection(string2, string3, null, 3);
                    } else if (n2 == 2) {
                        this.addIntoAssociationInfoCollection(string2, string3, null, field, field2, 3);
                    }
                    bl2 = true;
                }
                if (!bl2) {
                    if (n2 == 1) {
                        this.addIntoAssociationModelCollection(string2, string3, string3, 2);
                    } else if (n2 == 2) {
                        this.addIntoAssociationInfoCollection(string2, string3, string3, field, null, 2);
                    }
                }
            } else if (BaseUtility.isGenericTypeSupported(string3) && n2 == 1) {
                Column column = field.getAnnotation(Column.class);
                if (column != null && column.ignore()) {
                    return;
                }
                GenericModel genericModel = new GenericModel();
                genericModel.setTableName(DBUtility.getGenericTableName(string2, field.getName()));
                genericModel.setValueColumnName(DBUtility.convertToValidColumnName(field.getName()));
                genericModel.setValueColumnType(this.getColumnType(string3));
                genericModel.setValueIdColumnName(DBUtility.getGenericValueIdColumnName(string2));
                this.mGenericModels.add(genericModel);
            }
        }
    }

    private void addIntoAssociationModelCollection(String string2, String string3, String string4, int n2) {
        AssociationsModel associationsModel = new AssociationsModel();
        associationsModel.setTableName(DBUtility.getTableNameByClassName(string2));
        associationsModel.setAssociatedTableName(DBUtility.getTableNameByClassName(string3));
        associationsModel.setTableHoldsForeignKey(DBUtility.getTableNameByClassName(string4));
        associationsModel.setAssociationType(n2);
        this.mAssociationModels.add(associationsModel);
    }

    private void addIntoAssociationInfoCollection(String string2, String string3, String string4, Field field, Field field2, int n2) {
        AssociationsInfo associationsInfo = new AssociationsInfo();
        associationsInfo.setSelfClassName(string2);
        associationsInfo.setAssociatedClassName(string3);
        associationsInfo.setClassHoldsForeignKey(string4);
        associationsInfo.setAssociateOtherModelFromSelf(field);
        associationsInfo.setAssociateSelfFromOtherModel(field2);
        associationsInfo.setAssociationType(n2);
        this.mAssociationInfos.add(associationsInfo);
    }

    protected String getGenericTypeName(Field field) {
        Class<?> clazz = this.getGenericTypeClass(field);
        if (clazz != null) {
            return clazz.getName();
        }
        return null;
    }

    private ColumnModel convertFieldToColumnModel(Field field) {
        String string2 = field.getType().getName();
        String string3 = this.getColumnType(string2);
        boolean bl2 = true;
        boolean bl3 = false;
        String string4 = "";
        Column column = field.getAnnotation(Column.class);
        if (column != null) {
            bl2 = column.nullable();
            bl3 = column.unique();
            string4 = column.defaultValue();
        }
        ColumnModel columnModel = new ColumnModel();
        columnModel.setColumnName(DBUtility.convertToValidColumnName(field.getName()));
        columnModel.setColumnType(string3);
        columnModel.setNullable(bl2);
        columnModel.setUnique(bl3);
        columnModel.setDefaultValue(string4);
        return columnModel;
    }
}

