/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.komect.network.litepal.LitePalApplication;
import com.komect.network.litepal.LitePalDB;
import com.komect.network.litepal.parser.LitePalAttr;
import com.komect.network.litepal.parser.LitePalConfig;
import com.komect.network.litepal.parser.LitePalParser;
import com.komect.network.litepal.tablemanager.Connector;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.SharedUtil;
import com.komect.network.litepal.util.cipher.CipherUtil;
import java.io.File;

public class LitePal {
    private static Handler handler = new Handler(Looper.getMainLooper());

    public static void initialize(Context context) {
        LitePalApplication.sContext = context;
    }

    public static SQLiteDatabase getDatabase() {
        return Connector.getDatabase();
    }

    public static Handler getHandler() {
        return handler;
    }

    public static void use(LitePalDB litePalDB) {
        LitePalAttr litePalAttr = LitePalAttr.getInstance();
        litePalAttr.setDbName(litePalDB.getDbName());
        litePalAttr.setVersion(litePalDB.getVersion());
        litePalAttr.setStorage(litePalDB.getStorage());
        litePalAttr.setClassNames(litePalDB.getClassNames());
        if (!LitePal.isDefaultDatabase(litePalDB.getDbName())) {
            litePalAttr.setExtraKeyName(litePalDB.getDbName());
            litePalAttr.setCases("lower");
        }
        Connector.clearLitePalOpenHelperInstance();
    }

    public static void useDefault() {
        LitePalAttr.clearInstance();
        Connector.clearLitePalOpenHelperInstance();
    }

    public static boolean deleteDatabase(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            File file;
            if (!string2.endsWith(".db")) {
                string2 = string2 + ".db";
            }
            if ((file = LitePalApplication.getContext().getDatabasePath(string2)).exists()) {
                boolean bl2 = file.delete();
                if (bl2) {
                    LitePal.removeVersionInSharedPreferences(string2);
                    Connector.clearLitePalOpenHelperInstance();
                }
                return bl2;
            }
            String string3 = LitePalApplication.getContext().getExternalFilesDir("") + "/databases/";
            file = new File(string3 + string2);
            boolean bl3 = file.delete();
            if (bl3) {
                LitePal.removeVersionInSharedPreferences(string2);
                Connector.clearLitePalOpenHelperInstance();
            }
            return bl3;
        }
        return false;
    }

    public static void aesKey(String string2) {
        CipherUtil.aesKey = string2;
    }

    private static void removeVersionInSharedPreferences(String string2) {
        if (LitePal.isDefaultDatabase(string2)) {
            SharedUtil.removeVersion(null);
        } else {
            SharedUtil.removeVersion(string2);
        }
    }

    private static boolean isDefaultDatabase(String string2) {
        if (BaseUtility.isLitePalXMLExists()) {
            LitePalConfig litePalConfig;
            String string3;
            if (!string2.endsWith(".db")) {
                string2 = string2 + ".db";
            }
            if (!(string3 = (litePalConfig = LitePalParser.parseLitePalConfiguration()).getDbName()).endsWith(".db")) {
                string3 = string3 + ".db";
            }
            return string2.equalsIgnoreCase(string3);
        }
        return false;
    }
}

