/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.database;

import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.TestPoint;
import com.komect.network.bean.WiFiCoverage;
import com.komect.network.database.HistoryLog;
import com.komect.network.database.OrderEntity;
import com.komect.network.komectinnet.b.e;
import com.komect.network.komectinnet.bean.response.FamilyEntity;
import com.komect.network.litepal.crud.DataSupport;
import java.util.List;

public class DbManager
extends DataSupport {
    private String userId;
    private static DbManager manager;
    private Integer orderId;

    private DbManager(String string2) {
        this.userId = string2;
    }

    public static DbManager initialize(String string2) {
        if (manager == null || !e.a(DbManager.manager.userId, string2)) {
            manager = new DbManager(string2);
        }
        return manager;
    }

    public static DbManager getManager() {
        return manager;
    }

    public void saveHistory(String string2, int n2) {
        String[] stringArray = new String[]{"userId=? and keyword=? and histype=?", this.userId, string2, n2 + ""};
        HistoryLog historyLog = new HistoryLog().setUserId(this.userId).setKeyword(string2).setHisType(n2).setTime(System.currentTimeMillis());
        if (DataSupport.isExist(HistoryLog.class, stringArray)) {
            historyLog.updateAll(stringArray);
        } else {
            List<HistoryLog> list = this.getHistoryList(n2);
            if (list.size() >= 5) {
                HistoryLog historyLog2 = list.get(4);
                historyLog2.delete();
                historyLog.save();
            } else {
                historyLog.save();
            }
        }
    }

    public List<HistoryLog> getHistoryList(int n2) {
        return DataSupport.where("userId = ? and histype=?", this.userId, n2 + "").order("time desc").find(HistoryLog.class);
    }

    public void clearHistoryList(int n2) {
        String[] stringArray = new String[]{"userId=? and histype=?", this.userId, n2 + ""};
        DataSupport.deleteAll(HistoryLog.class, stringArray);
    }

    public void saveOrderEntity(OrderEntity orderEntity) {
        orderEntity.setUserId(this.userId);
        orderEntity.save();
        this.orderId = DataSupport.findLast(OrderEntity.class).getId();
    }

    public void updateOrderEntityWithBuildingInfo(FamilyEntity familyEntity) {
        OrderEntity orderEntity = DataSupport.findLast(OrderEntity.class);
        orderEntity.setSpecName(familyEntity.getSpecName());
        orderEntity.setPlanCity(familyEntity.getPlanCity());
        orderEntity.setArea(familyEntity.getArea());
        orderEntity.setPics(familyEntity.getPics());
        orderEntity.setObsPlanId(familyEntity.getObsPlanId());
        orderEntity.setCommName(familyEntity.getCommName());
        orderEntity.update(this.orderId.intValue());
    }

    public void updateOrderEntityRemoveBuildingInfo() {
        OrderEntity orderEntity = DataSupport.findLast(OrderEntity.class);
        orderEntity.setToDefault("planCity");
        orderEntity.setToDefault("obsPlanId");
        orderEntity.setToDefault("commName");
        orderEntity.update(this.orderId.intValue());
    }

    public void updateOrderEntityToSave() {
        OrderEntity orderEntity = DataSupport.findLast(OrderEntity.class);
        orderEntity.setSaved(true);
        orderEntity.update(this.orderId.intValue());
    }

    public List<OrderEntity> getAllOrderEntity() {
        return DataSupport.where("userId = ? and isSaved = 1", this.userId).order("id desc").find(OrderEntity.class);
    }

    public List<OrderEntity> getOrderEntityByKeyword(String string2) {
        return DataSupport.where("userId = ? and isSaved = 1 and (broadbandAccount like ? or orderNumber like ? or username like ? or mobile like ? or planCity like ?or commName like ?)", this.userId, "%" + string2 + "%", "%" + string2 + "%", "%" + string2 + "%", "%" + string2 + "%", "%" + string2 + "%", "%" + string2 + "%").order("id desc").find(OrderEntity.class);
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer n2) {
        this.orderId = n2;
    }

    public void saveDevice(NetworkDevice networkDevice, int n2) {
        try {
            NetworkDevice networkDevice2 = (NetworkDevice)networkDevice.clone();
            networkDevice2.setDataType(n2);
            networkDevice2.setForeignKey(this.getOrderId());
            networkDevice2.save();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    public void updateDevice(NetworkDevice networkDevice, int n2) {
        networkDevice.setDataType(n2);
        networkDevice.setForeignKey(this.getOrderId());
        networkDevice.updateAll("foreignkey = ? and datatype = ?", this.getOrderId() + "", n2 + "");
    }

    public void saveCoverage(WiFiCoverage wiFiCoverage, int n2) {
        try {
            WiFiCoverage wiFiCoverage2 = (WiFiCoverage)wiFiCoverage.clone();
            wiFiCoverage2.setDataType(n2);
            wiFiCoverage2.setForeignKey(this.getOrderId());
            wiFiCoverage2.save();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    public void updateCoverage(WiFiCoverage wiFiCoverage, int n2) {
        wiFiCoverage.setDataType(n2);
        wiFiCoverage.setForeignKey(this.getOrderId());
        wiFiCoverage.updateAll("foreignkey = ? and datatype = ?", this.getOrderId() + "", n2 + "");
    }

    public List<WiFiCoverage> getCoverages(int n2) {
        return DataSupport.where("foreignkey = ? and datatype = ?", this.getOrderId() + "", n2 + "").find(WiFiCoverage.class);
    }

    public WiFiCoverage getCoverage(int n2) {
        List<WiFiCoverage> list = DataSupport.where("foreignkey = ? and datatype = ?", this.getOrderId() + "", n2 + "").find(WiFiCoverage.class);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public void saveTP(TestPoint testPoint, int n2) {
        try {
            TestPoint testPoint2 = (TestPoint)testPoint.clone();
            testPoint2.setDataType(n2);
            testPoint2.setForeignKey(this.getOrderId());
            testPoint2.save();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    public void updateTP(TestPoint testPoint, int n2) {
        testPoint.setDataType(n2);
        testPoint.setForeignKey(this.getOrderId());
        testPoint.updateAll("foreignkey = ?", this.getOrderId() + "");
    }

    public List<NetworkDevice> getDeviceList(int n2) {
        return DataSupport.where("foreignkey = ? and datatype = ?", this.getOrderId() + "", n2 + "").find(NetworkDevice.class);
    }

    public List<TestPoint> getTestPoint(int n2) {
        return DataSupport.where("foreignkey = ? and datatype = ?", this.getOrderId() + "", n2 + "").find(TestPoint.class);
    }

    public void deleteAllDevice(int n2) {
        DataSupport.deleteAll(NetworkDevice.class, "foreignkey = ? and datatype = ?", this.getOrderId() + "", n2 + "");
    }

    public void deleteAllTP(int n2) {
        DataSupport.deleteAll(TestPoint.class, "foreignkey = ? and datatype = ?", this.getOrderId() + "", n2 + "");
    }

    public void deleteAllCoverage(int n2) {
        DataSupport.deleteAll(WiFiCoverage.class, "foreignkey = ? and datatype = ?", this.getOrderId() + "", n2 + "");
    }

    public void deleteAll(int n2) {
        this.deleteAllDevice(n2);
        this.deleteAllTP(n2);
        this.deleteAllCoverage(n2);
    }
}

