/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.widget.dropmenu;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.komect.network.R;
import com.komect.network.app.widget.dropmenu.DeviceUtils;
import java.util.List;

public class DropDownMenu
extends LinearLayout {
    private LinearLayout tabMenuView;
    private FrameLayout containerView;
    private FrameLayout popupMenuViews;
    private View maskView;
    private int current_tab_position = -1;
    private int dividerColor = -3355444;
    private int textSelectedColor = -7795579;
    private int textUnselectedColor = -15658735;
    private int maskColor = -2004318072;
    private int menuTextSize = 14;
    private int menuSelectedIcon;
    private int menuUnselectedIcon;
    private float menuHeighPercent = 0.5f;

    public DropDownMenu(Context context) {
        super(context, null);
    }

    public DropDownMenu(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public DropDownMenu(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.setOrientation(1);
        int n3 = -1;
        int n4 = -3355444;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.DropDownMenu);
        n4 = typedArray.getColor(R.styleable.DropDownMenu_ddunderlineColor, n4);
        this.dividerColor = typedArray.getColor(R.styleable.DropDownMenu_dddividerColor, this.dividerColor);
        this.textSelectedColor = typedArray.getColor(R.styleable.DropDownMenu_ddtextSelectedColor, this.textSelectedColor);
        this.textUnselectedColor = typedArray.getColor(R.styleable.DropDownMenu_ddtextUnselectedColor, this.textUnselectedColor);
        n3 = typedArray.getColor(R.styleable.DropDownMenu_ddmenuBackgroundColor, n3);
        this.maskColor = typedArray.getColor(R.styleable.DropDownMenu_ddmaskColor, this.maskColor);
        this.menuTextSize = typedArray.getDimensionPixelSize(R.styleable.DropDownMenu_ddmenuTextSize, this.menuTextSize);
        this.menuSelectedIcon = typedArray.getResourceId(R.styleable.DropDownMenu_ddmenuSelectedIcon, this.menuSelectedIcon);
        this.menuUnselectedIcon = typedArray.getResourceId(R.styleable.DropDownMenu_ddmenuUnselectedIcon, this.menuUnselectedIcon);
        this.menuHeighPercent = typedArray.getFloat(R.styleable.DropDownMenu_ddmenuMenuHeightPercent, this.menuHeighPercent);
        typedArray.recycle();
        this.tabMenuView = new LinearLayout(context);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.tabMenuView.setOrientation(0);
        this.tabMenuView.setBackgroundColor(n3);
        this.tabMenuView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView((View)this.tabMenuView, 0);
        View view = new View(this.getContext());
        view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.dpTpPx(1.0f)));
        view.setBackgroundColor(n4);
        this.addView(view, 1);
        this.containerView = new FrameLayout(context);
        this.containerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.containerView, 2);
    }

    public void setDropDownMenu(@NonNull List<String> list, @NonNull List<View> list2, @NonNull View view) {
        int n2;
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("params not match, tabTexts.size() should be equal popupViews.size()");
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            this.addTab(list, n2);
        }
        this.containerView.addView(view, 0);
        this.maskView = new View(this.getContext());
        this.maskView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.maskView.setBackgroundColor(this.maskColor);
        this.maskView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DropDownMenu.this.closeMenu();
            }
        });
        this.containerView.addView(this.maskView, 1);
        this.maskView.setVisibility(8);
        if (this.containerView.getChildAt(2) != null) {
            this.containerView.removeViewAt(2);
        }
        this.popupMenuViews = new FrameLayout(this.getContext());
        this.popupMenuViews.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, (int)((float)DeviceUtils.getScreenSize((Context)this.getContext()).y * this.menuHeighPercent)));
        this.popupMenuViews.setVisibility(8);
        this.containerView.addView((View)this.popupMenuViews, 2);
        for (n2 = 0; n2 < list2.size(); ++n2) {
            list2.get(n2).setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            this.popupMenuViews.addView(list2.get(n2), n2);
        }
    }

    private void addTab(@NonNull List<String> list, int n2) {
        final TextView textView = new TextView(this.getContext());
        textView.setSingleLine();
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setGravity(17);
        textView.setTextSize(0, (float)this.menuTextSize);
        textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        textView.setTextColor(this.textUnselectedColor);
        textView.setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(this.menuUnselectedIcon), null);
        textView.setText((CharSequence)list.get(n2));
        textView.setPadding(this.dpTpPx(5.0f), this.dpTpPx(12.0f), this.dpTpPx(5.0f), this.dpTpPx(12.0f));
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DropDownMenu.this.switchMenu((View)textView);
            }
        });
        this.tabMenuView.addView((View)textView);
        if (n2 < list.size() - 1) {
            View view = new View(this.getContext());
            view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.dpTpPx(0.5f), -1));
            view.setBackgroundColor(this.dividerColor);
            this.tabMenuView.addView(view);
        }
    }

    public void setTabText(String string2) {
        if (this.current_tab_position != -1) {
            ((TextView)this.tabMenuView.getChildAt(this.current_tab_position)).setText((CharSequence)string2);
        }
    }

    public void setTabClickable(boolean bl2) {
        for (int i2 = 0; i2 < this.tabMenuView.getChildCount(); i2 += 2) {
            this.tabMenuView.getChildAt(i2).setClickable(bl2);
        }
    }

    public void closeMenu() {
        if (this.current_tab_position != -1) {
            ((TextView)this.tabMenuView.getChildAt(this.current_tab_position)).setTextColor(this.textUnselectedColor);
            ((TextView)this.tabMenuView.getChildAt(this.current_tab_position)).setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(this.menuUnselectedIcon), null);
            this.popupMenuViews.setVisibility(8);
            this.popupMenuViews.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.dd_menu_out));
            this.maskView.setVisibility(8);
            this.maskView.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.dd_mask_out));
            this.current_tab_position = -1;
        }
    }

    public boolean isShowing() {
        return this.current_tab_position != -1;
    }

    private void switchMenu(View view) {
        System.out.println(this.current_tab_position);
        for (int i2 = 0; i2 < this.tabMenuView.getChildCount(); i2 += 2) {
            if (view == this.tabMenuView.getChildAt(i2)) {
                if (this.current_tab_position == i2) {
                    this.closeMenu();
                    continue;
                }
                if (this.current_tab_position == -1) {
                    this.popupMenuViews.setVisibility(0);
                    this.popupMenuViews.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.dd_menu_in));
                    this.maskView.setVisibility(0);
                    this.maskView.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.dd_mask_in));
                    this.popupMenuViews.getChildAt(i2 / 2).setVisibility(0);
                } else {
                    this.popupMenuViews.getChildAt(i2 / 2).setVisibility(0);
                }
                this.current_tab_position = i2;
                ((TextView)this.tabMenuView.getChildAt(i2)).setTextColor(this.textSelectedColor);
                ((TextView)this.tabMenuView.getChildAt(i2)).setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(this.menuSelectedIcon), null);
                continue;
            }
            ((TextView)this.tabMenuView.getChildAt(i2)).setTextColor(this.textUnselectedColor);
            ((TextView)this.tabMenuView.getChildAt(i2)).setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(this.menuUnselectedIcon), null);
            this.popupMenuViews.getChildAt(i2 / 2).setVisibility(8);
        }
    }

    public int dpTpPx(float f2) {
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        return (int)((double)TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)displayMetrics) + 0.5);
    }
}

