/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.widget;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.komect.network.R;
import com.komect.network.databinding.LayoutNetworkTopbarBinding;
import com.komect.network.databinding.TopBarConfig;
import com.zhy.autolayout.utils.AutoUtils;

public class TopBar
extends FrameLayout {
    private OnTopBarEventListener mOnTopBarEventListener;
    private LayoutNetworkTopbarBinding binding;

    public TopBar(Context context) {
        super(context);
        this.initContent(context);
    }

    public TopBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initContent(context);
    }

    public TopBar(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initContent(context);
    }

    private void initContent(Context context) {
        this.binding = (LayoutNetworkTopbarBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.layout_network_topbar, (ViewGroup)this, (boolean)false);
        this.addView(this.binding.getRoot());
        AutoUtils.autoSize((View)this.binding.getRoot());
        this.binding.btLeft.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TopBar.this.mOnTopBarEventListener != null) {
                    TopBar.this.mOnTopBarEventListener.onTopBarLeftClick(view);
                }
            }
        });
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                if (TopBar.this.mOnTopBarEventListener != null) {
                    TopBar.this.mOnTopBarEventListener.onTopBarRightClick(view);
                }
            }
        };
        this.binding.tvRight.setOnClickListener(onClickListener);
        this.binding.btRight.setOnClickListener(onClickListener);
        this.binding.ivRight.setOnClickListener(onClickListener);
    }

    public void setOnTopBarEventListener(OnTopBarEventListener onTopBarEventListener) {
        this.mOnTopBarEventListener = onTopBarEventListener;
    }

    public void setConfig(TopBarConfig topBarConfig) {
        this.binding.setConfig(topBarConfig);
        this.binding.executePendingBindings();
    }

    public ImageView getLeftIconView() {
        return this.binding.ivLeft;
    }

    public FrameLayout getLayout() {
        return this.binding.layoutTopbar;
    }

    public static interface OnTopBarEventListener {
        public void onTopBarLeftClick(View var1);

        public void onTopBarRightClick(View var1);
    }
}

