/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.widget;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import com.komect.network.R;
import com.komect.network.app.a.f;
import com.komect.network.app.a.i;
import com.komect.network.app.widget.Marker;
import com.komect.network.b.c;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.TestPoint;
import com.komect.network.databinding.LayoutNwReportBinding;
import com.komect.network.databinding.ReportConfig;
import com.zhy.autolayout.utils.AutoUtils;
import java.util.Collection;
import java.util.List;

public class ReportView
extends LinearLayout {
    private LayoutNwReportBinding binding;
    private f mDeviceAdapter;
    private i mPointAdapter;
    private Context context;

    public ReportView(Context context) {
        super(context);
        this.initContent(context);
    }

    public ReportView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initContent(context);
    }

    public ReportView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initContent(context);
    }

    private void initContent(Context context) {
        this.context = context;
        this.binding = (LayoutNwReportBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.layout_nw_report, (ViewGroup)this, (boolean)false);
        this.addView(this.binding.getRoot());
        AutoUtils.autoSize((View)this.binding.getRoot());
    }

    public void setConfig(ReportConfig reportConfig) {
        this.handleDeviceList(reportConfig.getDevices(), reportConfig.isHasFamily(), reportConfig.isNoShowDeviceTable());
        this.handleTpList(reportConfig.getTestPoints(), reportConfig.isHasFamily());
        this.binding.setConfig(reportConfig);
        this.binding.executePendingBindings();
    }

    private void handleDeviceList(List<NetworkDevice> list, boolean bl2, boolean bl3) {
        if (list != null && list.size() > 0) {
            if (!bl3) {
                this.binding.lyDeviceForm.setVisibility(0);
                this.mDeviceAdapter = new f();
                this.binding.deviceListView.setAdapter((ListAdapter)this.mDeviceAdapter);
                this.mDeviceAdapter.b((Collection<NetworkDevice>)list);
            }
            if (bl2) {
                for (NetworkDevice networkDevice : list) {
                    this.addDeviceMarker(networkDevice);
                }
            }
        } else {
            this.binding.lyDeviceForm.setVisibility(8);
        }
    }

    private void handleTpList(List<TestPoint> list, boolean bl2) {
        if (list != null) {
            this.binding.lyTpForm.setVisibility(0);
            this.mPointAdapter = new i();
            this.binding.testListView.setAdapter((ListAdapter)this.mPointAdapter);
            if (list.size() > 0) {
                this.mPointAdapter.b((Collection<TestPoint>)list);
                if (bl2) {
                    for (TestPoint testPoint : list) {
                        this.addTpMarker(testPoint);
                    }
                }
            }
        } else {
            this.binding.lyTpForm.setVisibility(8);
        }
    }

    private void addDeviceMarker(NetworkDevice networkDevice) {
        float f2 = networkDevice.getX();
        float f3 = networkDevice.getY();
        if (networkDevice.getDeviceType() != null) {
            Marker marker = c.a(this.context, c.a(networkDevice.getDeviceType()));
            marker.setMarkerType(2);
            marker.setIndex(Integer.parseInt(networkDevice.getSequence()));
            marker.setObject(networkDevice);
            this.binding.lyHeatMap.setPosition(marker, f2, f3);
        }
    }

    private void addTpMarker(TestPoint testPoint) {
        float f2 = testPoint.getX();
        float f3 = testPoint.getY();
        Marker marker = c.a(this.context, R.drawable.test_marker);
        marker.setMarkerType(1);
        marker.setIndex(Integer.parseInt(testPoint.getSequence()));
        marker.setObject(testPoint);
        this.binding.lyHeatMap.setPosition(marker, f2, f3);
    }
}

