/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.komect.network.R;
import com.komect.network.app.widget.Marker;
import java.util.ArrayList;

public class DragRelativeLayout
extends RelativeLayout
implements View.OnTouchListener {
    private int markerIndex;
    private int screenWidth;
    private boolean isIntercept = false;
    private int startDownX;
    private int startDownY;
    private int lastMoveX;
    private int lastMoveY;
    private ImageView heatImage;

    public DragRelativeLayout(Context context) {
        super(context);
        this.init();
    }

    public DragRelativeLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public DragRelativeLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init();
    }

    private void init() {
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.screenWidth = displayMetrics.widthPixels;
    }

    public void addMarker(Marker marker) {
        ++this.markerIndex;
        marker.setText(String.valueOf(marker.getIndex()));
        marker.setOnTouchListener(this);
        this.addView((View)marker, this.markerIndex);
    }

    public void setPosition(Marker marker, float f2, float f3) {
        ++this.markerIndex;
        marker.setText(String.valueOf(marker.getIndex()));
        this.addView((View)marker, this.markerIndex);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.leftMargin = (int)f2;
        layoutParams.topMargin = (int)f3;
        layoutParams.setMargins((int)f2, (int)f3, 0, 0);
        marker.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public ArrayList<Marker> getChilds() {
        ArrayList<Marker> arrayList = new ArrayList<Marker>();
        for (int i2 = 1; i2 < this.getChildCount(); ++i2) {
            Marker marker = (Marker)this.getChildAt(i2);
            arrayList.add(marker);
        }
        return arrayList;
    }

    public void removeMarkers() {
        if (this.getChildCount() > 1) {
            this.removeViews(1, this.getChildCount() - 1);
            this.markerIndex = 0;
        }
    }

    public void removeMarkers(int n2) {
        if (n2 < this.getChildCount() - 1) {
            this.removeViews(n2 + 1, this.getChildCount() - n2 - 1);
            this.markerIndex = this.getChildCount() - 1;
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        int n2 = motionEvent.getAction();
        switch (n2) {
            case 0: {
                this.startDownX = this.lastMoveX = (int)motionEvent.getRawX();
                this.startDownY = this.lastMoveY = (int)motionEvent.getRawY();
                break;
            }
            case 2: {
                int n3 = (int)motionEvent.getRawX() - this.lastMoveX;
                int n4 = (int)motionEvent.getRawY() - this.lastMoveY;
                int n5 = view.getLeft() + n3;
                int n6 = view.getTop() + n4;
                int n7 = view.getRight() + n3;
                int n8 = view.getBottom() + n4;
                if (n5 < 0) {
                    n5 = 0;
                    n7 = n5 + view.getWidth();
                }
                if (n7 > this.screenWidth) {
                    n7 = this.screenWidth;
                    n5 = n7 - view.getWidth();
                }
                if (n6 < 0) {
                    n6 = 0;
                    n8 = n6 + view.getHeight();
                }
                if (n8 > this.getHeight()) {
                    n8 = this.getHeight();
                    n6 = n8 - view.getHeight();
                }
                view.layout(n5, n6, n7, n8);
                this.lastMoveX = (int)motionEvent.getRawX();
                this.lastMoveY = (int)motionEvent.getRawY();
                break;
            }
            case 1: {
                int n9 = Math.abs((int)motionEvent.getRawX() - this.startDownX);
                int n10 = Math.abs((int)motionEvent.getRawY() - this.startDownY);
                this.isIntercept = 0 != n9 || 0 != n10;
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.leftMargin = view.getLeft();
                layoutParams.topMargin = view.getTop();
                layoutParams.setMargins(view.getLeft(), view.getTop(), 0, 0);
                view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
        return this.isIntercept;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.heatImage = (ImageView)this.findViewById(R.id.img_heat_map);
    }
}

