/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.komect.network.R;
import com.komect.network.app.activity.DeviceAddActivity;
import com.komect.network.app.activity.PostInstallActivity;
import com.komect.network.app.fragment.BaseFragment;
import com.komect.network.app.widget.StepView;
import com.komect.network.b.f;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.StepEntity;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.FragmentSimpProjectDesignBinding;
import com.komect.network.databinding.ReportConfig;
import com.komect.network.komectinnet.event.a;
import com.komect.network.litepal.crud.DataSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.greenrobot.eventbus.Subscribe;

public class SimpProjectDesignFragment
extends BaseFragment
implements StepView.OnItemClickListener {
    public static final String INTENT_ADD_DEVICE = "network_device";
    public static final int REQUEST_ADD_DEVICE = 1;
    private FragmentSimpProjectDesignBinding binding;
    private com.komect.network.app.a.f mDeviceAdapter;
    private ArrayList<NetworkDevice> deviceList = new ArrayList();
    private boolean isFirstAddDevice = true;
    private boolean isConfirmedPlan;
    private DbManager dbManager;
    private OrderEntity orderEntity;
    @Inject
    f cacheUtil;
    @Inject
    StepEntity stepEntity;

    public static SimpProjectDesignFragment newInstance() {
        return new SimpProjectDesignFragment();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.getAppComponent().a(this);
        this.dbManager = DbManager.getManager();
        if (this.stepEntity.getStepTwo() == 0) {
            this.stepEntity.setStepTwo(1);
        }
        this.initData();
    }

    private void initData() {
        this.orderEntity = DataSupport.findLast(OrderEntity.class);
        List<NetworkDevice> list = this.dbManager.getDeviceList(2);
        if (!list.isEmpty()) {
            this.deviceList = (ArrayList)list;
        }
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.binding = (FragmentSimpProjectDesignBinding)DataBindingUtil.inflate((LayoutInflater)layoutInflater, (int)R.layout.fragment_simp_project_design, (ViewGroup)viewGroup, (boolean)false);
        this.binding.setFrag(this);
        this.binding.setOrder(this.orderEntity);
        if (!this.deviceList.isEmpty()) {
            this.showCompletedView(true);
        }
        this.mDeviceAdapter = new com.komect.network.app.a.f();
        this.binding.deviceListView.setAdapter((ListAdapter)this.mDeviceAdapter);
        this.mDeviceAdapter.b((Collection<NetworkDevice>)this.deviceList);
        return this.binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        this.initStepView();
    }

    private void initStepView() {
        this.binding.stepView.setCurrentIndex(2).setStepEntity(this.stepEntity).setOnItemClickListener(this);
    }

    private void updateStepState(int n2, int n3) {
        switch (n2) {
            case 2: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepTwo(n3));
                break;
            }
            case 3: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepThree(n3));
                break;
            }
        }
    }

    private void resetView() {
        this.deviceList.clear();
        this.isFirstAddDevice = true;
        this.mDeviceAdapter.b((Collection<NetworkDevice>)this.deviceList);
    }

    public void showAddDeviceView(View view) {
        if (this.mDeviceAdapter.getCount() < 12) {
            Bundle bundle = new Bundle();
            bundle.putBoolean("is_network_design", true);
            Intent intent = new Intent((Context)this.getActivity(), DeviceAddActivity.class);
            intent.putExtra("bundle", bundle);
            this.startActivityForResult(intent, 1);
        } else {
            Toast.makeText((Context)this.getActivity(), (int)R.string.unable_add_more_devices, (int)0).show();
        }
    }

    public void reviews(View view) {
        if (this.deviceList.isEmpty() || this.deviceList.size() == 1 && this.deviceList.get(0).getDeviceName().equals("-")) {
            Toast.makeText((Context)this.getActivity(), (int)R.string.nw_please_add_device, (int)0).show();
            return;
        }
        this.updateStepState(2, 2);
        this.showCompletedView(true);
        this.saveProjectDesignData();
    }

    private void showCompletedView(boolean bl2) {
        this.isConfirmedPlan = bl2;
        this.showUserInfo(bl2);
        this.showOrderInfo(bl2);
        if (bl2) {
            this.binding.btnStartTest.setVisibility(8);
            this.binding.btnRetest.setVisibility(0);
            this.binding.lyActionButton.setVisibility(8);
            this.binding.lyCmpActionButton.setVisibility(0);
        } else {
            this.binding.btnStartTest.setVisibility(0);
            this.binding.btnRetest.setVisibility(8);
            this.binding.lyActionButton.setVisibility(0);
            this.binding.lyCmpActionButton.setVisibility(8);
        }
    }

    public void onRedesign(View view) {
        this.updateStepState(2, 1);
        if (this.stepEntity.getStepThree() != 0) {
            this.updateStepState(3, 0);
        }
        this.showCompletedView(false);
        this.dbManager.deleteAll(2);
        this.dbManager.deleteAll(3);
        this.cacheUtil.c("cache_config_design");
    }

    private void showUserInfo(boolean bl2) {
        if (bl2) {
            this.binding.includeUserInfo.lyUserInfo.setVisibility(0);
            return;
        }
        this.binding.includeUserInfo.lyUserInfo.setVisibility(8);
    }

    private void showOrderInfo(boolean bl2) {
        if (bl2) {
            this.binding.lyOrderInfo.setVisibility(0);
            return;
        }
        this.binding.lyOrderInfo.setVisibility(8);
    }

    public void onActivityResult(int n2, int n3, Intent intent) {
        this.getActivity();
        if (n3 == -1 && n2 == 1) {
            NetworkDevice networkDevice = (NetworkDevice)intent.getParcelableExtra(INTENT_ADD_DEVICE);
            if (this.isFirstAddDevice) {
                this.isFirstAddDevice = false;
                this.deviceList.clear();
            }
            this.deviceList.add(networkDevice);
            this.mDeviceAdapter.b((Collection<NetworkDevice>)this.deviceList);
        }
    }

    public void onNextStep() {
        final Intent intent = new Intent((Context)this.getActivity(), PostInstallActivity.class);
        if (this.isConfirmedPlan) {
            this.getActivity().startActivity(intent);
        } else {
            this.showAlertDialog(null, this.getString(R.string.unconfirmed_skip_step), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n2) {
                    SimpProjectDesignFragment.this.getActivity().startActivity(intent);
                }
            });
        }
    }

    private void saveProjectDesignData() {
        for (NetworkDevice networkDevice : this.deviceList) {
            this.dbManager.saveDevice(networkDevice, 2);
        }
        ReportConfig reportConfig = new ReportConfig().setTitle(this.getString(R.string.intelligent_networking_scheme)).setMapTitle(this.getString(R.string.nw_network_design)).setDevices(this.deviceList).setHasFamily(false);
        this.cacheUtil.a("cache_config_design", reportConfig);
    }

    @Override
    public void onItemClick(View view, int n2) {
        if (!this.isConfirmedPlan) {
            this.updateStepState(2, -1);
        }
        if (n2 == 3) {
            this.onNextStep();
        } else {
            this.getActivity().onBackPressed();
        }
    }

    @Override
    @Subscribe
    public void onDispatchEvent(a a2) {
    }
}

