/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.fragment;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.komect.network.R;
import com.komect.network.a.a;
import com.komect.network.app.a.g;
import com.komect.network.app.activity.ReportActivity;
import com.komect.network.app.fragment.BaseFragment;
import com.komect.network.app.widget.LoadMoreListView;
import com.komect.network.bean.SearchProfile;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.FragmentRecordListBinding;
import com.komect.network.typeenum.ListTypeEnum;
import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;

public class QueryRecordListFragment
extends BaseFragment
implements SwipeRefreshLayout.OnRefreshListener,
AdapterView.OnItemClickListener,
LoadMoreListView.OnRefreshListener {
    @Inject
    SearchProfile searchProfile;
    private FragmentRecordListBinding binding;
    private g adapter;
    private DbManager dbManager;
    private List<OrderEntity> totalList;
    private int pageOffset;
    private static final int PAGE_SIZE = 20;

    @Override
    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        this.getAppComponent().a(this);
        this.binding = (FragmentRecordListBinding)DataBindingUtil.inflate((LayoutInflater)layoutInflater, (int)R.layout.fragment_record_list, (ViewGroup)viewGroup, (boolean)false);
        this.adapter = new g();
        this.binding.searchList.setAdapter((ListAdapter)this.adapter);
        this.dbManager = DbManager.getManager();
        this.binding.swipeGoogleAndLoadmoreRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.binding.searchList.setOnRefreshListener(this);
        this.binding.searchList.setOnItemClickListener(this);
        return this.binding.getRoot();
    }

    @Override
    public void onHiddenChanged(boolean bl2) {
        if (!bl2) {
            this.firstLoadList();
        }
    }

    public void firstLoadList() {
        this.totalList = this.dbManager.getOrderEntityByKeyword((String)this.searchProfile.keyWord.get());
        this.showList(ListTypeEnum.FirstLoad);
    }

    public void onRefresh() {
        this.showList(ListTypeEnum.Refresh);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
        Bundle bundle = new Bundle();
        bundle.putSerializable("order_entity", (Serializable)this.adapter.a().get(n2));
        new a().a(ReportActivity.class).a(bundle).g();
    }

    @Override
    public void onLoadingMore() {
        this.showList(ListTypeEnum.LoadMore);
    }

    private void showList(ListTypeEnum listTypeEnum) {
        switch (listTypeEnum) {
            case FirstLoad: 
            case Refresh: {
                this.binding.swipeGoogleAndLoadmoreRefreshLayout.setRefreshing(true);
                this.pageOffset = 0;
                this.adapter.b(this.totalList.subList(this.pageOffset, 20 < this.totalList.size() - this.pageOffset ? 20 : this.totalList.size() - this.pageOffset));
                this.pageOffset += 20;
                this.binding.swipeGoogleAndLoadmoreRefreshLayout.setRefreshing(false);
                break;
            }
            case LoadMore: {
                if (this.pageOffset <= this.totalList.size()) {
                    this.adapter.a(this.totalList.subList(this.pageOffset, 20 < this.totalList.size() - this.pageOffset ? this.pageOffset + 20 : this.totalList.size()));
                    this.pageOffset += 20;
                    this.binding.searchList.loadMoreComplete();
                    break;
                }
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u65e0\u66f4\u591a\u6570\u636e", (int)0).show();
                this.binding.searchList.loadMoreComplete();
                break;
            }
        }
    }
}

