/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.komect.network.R;
import com.komect.network.a.a;
import com.komect.network.app.a.i;
import com.komect.network.app.activity.NetworkTestActivity;
import com.komect.network.app.activity.OrderInfoActivity;
import com.komect.network.app.activity.PreInstallTestActivity;
import com.komect.network.app.activity.ProjectDesignActivity;
import com.komect.network.app.activity.TrstAddActivity;
import com.komect.network.app.fragment.BaseFragment;
import com.komect.network.app.widget.Marker;
import com.komect.network.app.widget.StepView;
import com.komect.network.b.c;
import com.komect.network.b.f;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.StepEntity;
import com.komect.network.bean.TestPoint;
import com.komect.network.bean.WiFiCoverage;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.FragmentPostInstallBinding;
import com.komect.network.databinding.ReportConfig;
import com.komect.network.litepal.crud.DataSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;

public class PostInstallFragment
extends BaseFragment
implements StepView.OnItemClickListener {
    public static final String INTENT_TEST_POINT = "test_point";
    public static final String INTENT_TEST_COUNT = "test_count";
    public static final String INTENT_TOTAL_ADDED = "total_added";
    public static final String INTENT_POINT_LIST = "test_point_list";
    public static final int REQUEST_ADD_TRST = 2;
    public static final int REQUEST_START_TEST = 3;
    private FragmentPostInstallBinding binding;
    private com.komect.network.app.a.f mDeviceAdapter;
    private i mPointAdapter;
    private WiFiCoverage coverage = new WiFiCoverage();
    private List<NetworkDevice> deviceList = new ArrayList<NetworkDevice>();
    private List<TestPoint> pointList = new ArrayList<TestPoint>();
    private List<TestPoint> pointListBackup = new ArrayList<TestPoint>();
    private List<TestPoint> testPointsPre;
    private List<TestPoint> oldTestPoints;
    private boolean isFirstAddTest = true;
    private boolean isConfirmedPlan;
    private boolean isPreTestDone;
    private boolean isCompleteTest;
    private DbManager dbManager;
    private OrderEntity orderEntity;
    private WiFiCoverage designCoverage;
    private ReportConfig pretestReportConfig;
    private ReportConfig designReportConfig;
    private ReportConfig postReportConfig;
    @Inject
    f cacheUtil;
    @Inject
    StepEntity stepEntity;

    public static PostInstallFragment newInstance() {
        return new PostInstallFragment();
    }

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.getAppComponent().a(this);
        this.dbManager = DbManager.getManager();
        if (this.stepEntity.getStepThree() == 0) {
            this.stepEntity.setStepThree(1);
        }
        this.initData();
    }

    private void initData() {
        this.orderEntity = DataSupport.findLast(OrderEntity.class);
        this.coverage.setHouseImg(this.orderEntity.getPics());
        this.coverage.setWifiMap(this.orderEntity.getPics());
        this.isPreTestDone = this.stepEntity.getStepOne() == 2;
        this.isConfirmedPlan = this.stepEntity.getStepTwo() == 2;
        this.oldTestPoints = this.dbManager.getTestPoint(3);
        this.deviceList = this.dbManager.getDeviceList(2);
        if (this.stepEntity.getStepThree() == 2) {
            this.pointList = this.oldTestPoints;
            WiFiCoverage wiFiCoverage = this.dbManager.getCoverage(3);
            if (wiFiCoverage != null) {
                this.coverage = wiFiCoverage;
            }
        } else {
            if (this.isPreTestDone) {
                this.testPointsPre = this.dbManager.getTestPoint(4);
            }
            if (this.isConfirmedPlan) {
                this.designCoverage = this.dbManager.getCoverage(2);
            }
        }
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.binding = (FragmentPostInstallBinding)DataBindingUtil.inflate((LayoutInflater)layoutInflater, (int)R.layout.fragment_post_install, (ViewGroup)viewGroup, (boolean)false);
        this.binding.layoutBuildingInfo.lyBuildingInfo.setVisibility(0);
        this.binding.setFrag(this);
        this.binding.setOrder(this.orderEntity);
        this.binding.setProfile(this.coverage);
        this.mDeviceAdapter = new com.komect.network.app.a.f();
        this.binding.deviceListView.setAdapter((ListAdapter)this.mDeviceAdapter);
        this.mPointAdapter = new i();
        this.binding.testListView.setAdapter((ListAdapter)this.mPointAdapter);
        this.initWiFiMap();
        this.handleProjectDesignDevice();
        this.handlePreInstallTP();
        this.mDeviceAdapter.b((Collection<NetworkDevice>)this.deviceList);
        this.mPointAdapter.b((Collection<TestPoint>)this.pointList);
        return this.binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        this.initStepView();
    }

    private void initWiFiMap() {
        if (this.stepEntity.getStepThree() == 2) {
            this.showTestCompletedView(this.coverage, this.oldTestPoints, true);
        }
    }

    private void handlePreInstallTP() {
        if (this.testPointsPre != null && !this.testPointsPre.isEmpty()) {
            this.pointList.addAll(this.testPointsPre);
            this.pointListBackup.addAll(this.testPointsPre);
            for (TestPoint testPoint : this.testPointsPre) {
                Marker marker = c.a(this.getContext(), R.drawable.test_marker);
                marker.setIndex(Integer.parseInt(testPoint.getSequence()));
                marker.setMarkerType(1);
                marker.setObject(testPoint);
                this.binding.lyHeatMap.setPosition(marker, testPoint.getX(), testPoint.getY());
            }
        }
    }

    private void handleProjectDesignDevice() {
        if (this.deviceList.size() > 0) {
            for (NetworkDevice networkDevice : this.deviceList) {
                int n2 = c.a(networkDevice.getDeviceType());
                Marker marker = c.a(this.getContext(), n2);
                marker.setIndex(Integer.parseInt(networkDevice.getSequence()));
                marker.setMarkerType(2);
                marker.setObject(networkDevice);
                this.binding.lyHeatMap.setPosition(marker, networkDevice.getX(), networkDevice.getY());
            }
        }
    }

    private void initStepView() {
        this.binding.stepView.setCurrentIndex(3).setStepEntity(this.stepEntity).setOnItemClickListener(this);
    }

    private void updateStepState(int n2, int n3) {
        this.binding.stepView.setStepEntity(this.stepEntity.setStepThree(n3));
    }

    public void showAddTestView(View view) {
        if (this.mPointAdapter.getCount() < 20) {
            Bundle bundle = new Bundle();
            bundle.putInt(INTENT_TOTAL_ADDED, this.mPointAdapter.getCount());
            Intent intent = new Intent((Context)this.getActivity(), TrstAddActivity.class);
            intent.putExtra("bundle", bundle);
            this.startActivityForResult(intent, 2);
        } else {
            Toast.makeText((Context)this.getActivity(), (int)R.string.nw_unable_add_more_tps, (int)0).show();
        }
    }

    public void onReset(View view) {
        this.resetView();
    }

    private void resetView() {
        this.isFirstAddTest = true;
        this.pointList.clear();
        this.pointListBackup.clear();
        if (this.testPointsPre != null && this.isPreTestDone) {
            this.pointList.addAll(this.testPointsPre);
            this.pointListBackup.addAll(this.testPointsPre);
            if (this.isConfirmedPlan) {
                this.binding.lyHeatMap.removeMarkers(this.deviceList.size() + this.testPointsPre.size());
            } else {
                this.binding.lyHeatMap.removeMarkers(this.testPointsPre.size());
            }
            this.mPointAdapter.b((Collection<TestPoint>)this.pointList);
        } else if (this.isConfirmedPlan) {
            this.binding.lyHeatMap.removeMarkers(this.deviceList.size());
            this.mPointAdapter.b((Collection<TestPoint>)this.pointListBackup);
        } else {
            this.binding.lyHeatMap.removeMarkers(0);
            this.mPointAdapter.b((Collection<TestPoint>)this.pointListBackup);
        }
    }

    public void startTest(View view) {
        if (this.pointList.isEmpty() || this.pointList.size() == 1 && this.pointList.get(0).getPosition().equals("-")) {
            Toast.makeText((Context)this.getActivity(), (int)R.string.nw_please_add_tps, (int)0).show();
            return;
        }
        this.binding.scrollviewLayout.scrollTo(0, 0);
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(INTENT_POINT_LIST, this.getTpList());
        Intent intent = new Intent((Context)this.getActivity(), NetworkTestActivity.class);
        intent.putExtra("bundle", bundle);
        this.startActivityForResult(intent, 3);
    }

    private void showTestCompletedView(WiFiCoverage wiFiCoverage, List<TestPoint> list, boolean bl2) {
        this.isCompleteTest = bl2;
        this.showUserInfo(bl2);
        this.showOrderInfo(bl2);
        this.showPreTestReport(bl2);
        this.showProjectDesign(bl2);
        if (bl2) {
            this.binding.btnStartTest.setVisibility(8);
            this.binding.btnRetest.setVisibility(0);
            this.binding.lyMainContent.setVisibility(8);
            this.showPostReport(true, wiFiCoverage, list);
        } else {
            this.binding.btnStartTest.setVisibility(0);
            this.binding.btnRetest.setVisibility(8);
            this.binding.lyMainContent.setVisibility(0);
            this.showPostReport(false, null, null);
        }
        this.binding.setProfile(wiFiCoverage);
        if (list != null && list.size() > 0) {
            this.mPointAdapter.b((Collection<TestPoint>)list);
        }
    }

    public void onRetest(View view) {
        this.updateStepState(3, 1);
        this.dbManager.deleteAll(3);
        this.showTestCompletedView(this.coverage.reset(), this.pointListBackup, false);
    }

    private void showUserInfo(boolean bl2) {
        if (bl2) {
            this.binding.includeUserInfo.lyUserInfo.setVisibility(0);
            return;
        }
        this.binding.includeUserInfo.lyUserInfo.setVisibility(8);
    }

    private void showOrderInfo(boolean bl2) {
        if (bl2) {
            this.binding.lyOrderInfo.setVisibility(0);
            return;
        }
        this.binding.lyOrderInfo.setVisibility(8);
    }

    private void showPreTestReport(boolean bl2) {
        if (bl2) {
            this.pretestReportConfig = (ReportConfig)this.cacheUtil.b("cache_config_pre");
            if (this.pretestReportConfig != null) {
                this.binding.lyPretestReport.setConfig(this.pretestReportConfig);
                this.binding.lyPretestReport.setVisibility(0);
            }
        } else {
            this.binding.lyPretestReport.setVisibility(8);
        }
    }

    private void showProjectDesign(boolean bl2) {
        if (bl2) {
            this.designReportConfig = (ReportConfig)this.cacheUtil.b("cache_config_design");
            if (this.designReportConfig != null) {
                this.binding.lyDesignReport.setConfig(this.designReportConfig);
                this.binding.lyDesignReport.setVisibility(0);
            }
        } else {
            this.binding.lyDesignReport.setVisibility(8);
        }
    }

    private void showPostReport(boolean bl2, WiFiCoverage wiFiCoverage, List<TestPoint> list) {
        if (bl2) {
            if (list == null || list.size() < 1) {
                return;
            }
            this.postReportConfig = new ReportConfig().setTitle(this.getString(R.string.post_install_test_plan)).setMapTitle(this.getString(R.string.nw_wifi_coverage_heatmap)).setDevices(this.deviceList).setTestPoints(list).setHasFamily(true).setNoShowDeviceTable(true);
            if (wiFiCoverage != null) {
                this.postReportConfig = this.postReportConfig.setCoverage(wiFiCoverage.getReliableRate()).setMapImg(wiFiCoverage.getWifiMap());
            }
            this.binding.lyPostReport.setConfig(this.postReportConfig);
            this.binding.lyPostReport.setVisibility(0);
        } else {
            this.binding.lyPostReport.setVisibility(8);
        }
    }

    public void onActivityResult(int n2, int n3, Intent intent) {
        this.getActivity();
        if (n3 == -1) {
            if (n2 == 2) {
                TestPoint testPoint = (TestPoint)intent.getParcelableExtra(INTENT_TEST_POINT);
                int n4 = intent.getIntExtra(INTENT_TEST_COUNT, 0);
                if (this.isFirstAddTest) {
                    this.isFirstAddTest = false;
                    this.pointList.clear();
                    this.pointListBackup.clear();
                    if (this.testPointsPre != null) {
                        this.pointList.addAll(this.testPointsPre);
                        this.pointListBackup.addAll(this.testPointsPre);
                    }
                }
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.pointList.add(testPoint);
                    this.pointListBackup.add(testPoint);
                    Marker marker = c.a(this.getContext(), R.drawable.test_marker);
                    marker.setMarkerType(1);
                    marker.setObject(testPoint);
                    marker.setIndex(this.pointList.size());
                    marker.setParentView((View)this.binding.lyHeatMap);
                    this.binding.lyHeatMap.addMarker(marker);
                }
                this.mPointAdapter.b((Collection<TestPoint>)this.pointList);
            }
            if (n2 == 3) {
                if (this.designCoverage != null) {
                    this.coverage.setReliableRate(this.designCoverage.getReliableRate());
                    this.coverage.setWifiMap(this.designCoverage.getWifiMap());
                }
                this.pointList = intent.getParcelableArrayListExtra(INTENT_TEST_POINT);
                this.showTestCompletedView(this.coverage, this.pointList, true);
                this.savePostInstallData(this.coverage, this.pointList);
                this.updateStepState(3, 2);
            }
        }
    }

    @Override
    public void onItemClick(View view, int n2) {
        if (!this.isCompleteTest) {
            this.updateStepState(3, -1);
        }
        if (n2 == 2) {
            new a().a(true).a(ProjectDesignActivity.class).g();
        } else {
            new a().a(true).a(PreInstallTestActivity.class).g();
        }
    }

    public ArrayList<TestPoint> getTpList() {
        ArrayList<TestPoint> arrayList = new ArrayList<TestPoint>();
        ArrayList<Marker> arrayList2 = this.binding.lyHeatMap.getChilds();
        for (Marker marker : arrayList2) {
            if (marker.getMarkerType() != 1) continue;
            TestPoint testPoint = (TestPoint)marker.getObject();
            float f2 = marker.getX();
            float f3 = marker.getY();
            testPoint.setX(f2);
            testPoint.setY(f3);
            arrayList.add(testPoint);
        }
        return arrayList;
    }

    private void savePostInstallData(WiFiCoverage wiFiCoverage, List<TestPoint> list) {
        for (TestPoint testPoint : list) {
            this.dbManager.saveTP(testPoint, 3);
        }
        this.dbManager.saveCoverage(wiFiCoverage, 3);
    }

    public void onConfirmedPress() {
        if (this.isCompleteTest) {
            this.startNextPage();
        } else {
            this.showAlertDialog(null, this.getString(R.string.postinstall_undone_skip_step), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n2) {
                    PostInstallFragment.this.startNextPage();
                }
            });
        }
    }

    private void startNextPage() {
        this.dbManager.updateOrderEntityToSave();
        this.cacheUtil.c("cache_config_pre");
        this.cacheUtil.c("cache_config_design");
        new a().a(0x4000000).a(OrderInfoActivity.class).g();
    }
}

