/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.fragment;

import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import com.komect.network.R;
import com.komect.network.app.a.c;
import com.komect.network.app.fragment.BaseFragment;
import com.komect.network.app.widget.spinner.NiceSpinner;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.databinding.DevicePresenter;
import com.komect.network.databinding.FragNewDeviceBinding;
import com.komect.network.komectinnet.event.b;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class NewDeviceFragment
extends BaseFragment
implements AdapterView.OnItemClickListener,
c.a {
    public static final int RESULT_OK = -1;
    public static final String TAG_SPINNER = "type_spinner";
    private List<String> deviceTypes = new LinkedList<String>(Arrays.asList("\u5168\u90e8", "\u8def\u7531\u5668", "\u7f51\u5173", "POE\u4ea4\u6362\u673a", "AP\u9762\u677f", "\u7535\u529b\u732b", "WiFi\u653e\u5927\u5668", "\u5176\u4ed6"));
    private List<String> positions = new LinkedList<String>(Arrays.asList("\u5ba2\u5385", "\u9910\u5385", "\u53a8\u623f", "\u4e3b\u5367", "\u6b21\u5367", "\u4e66\u623f", "\u5c0f\u5b69\u623f", "\u4e3b\u536b", "\u6b21\u536b", "\u9633\u53f0", "\u5176\u4ed6"));
    private NiceSpinner typeSpinner;
    private NiceSpinner positionSpinner;
    private ArrayList<NetworkDevice> deviceList = new ArrayList();
    private ArrayList<NetworkDevice> filterList;
    private int page = 0;
    public static final int PAGE_SIZE = 20;
    private int selectDeviceIndex = 0;
    private RecyclerView mRecyclerView;
    private c deviceAdapter;
    private FragNewDeviceBinding binding;
    @Inject
    DevicePresenter presenter;

    public static NewDeviceFragment newInstance() {
        return new NewDeviceFragment();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.getAppComponent().a(this);
        this.presenter.getOwnDeviceList(this.page, 20);
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.binding = (FragNewDeviceBinding)DataBindingUtil.inflate((LayoutInflater)layoutInflater, (int)R.layout.frag_new_device, (ViewGroup)viewGroup, (boolean)false);
        this.binding.setFrag(this);
        this.typeSpinner = this.binding.spinnerType;
        this.typeSpinner.attachDataSource(this.deviceTypes);
        this.typeSpinner.addOnItemClickListener(this);
        this.positionSpinner = this.binding.spinnerPosition;
        this.positionSpinner.attachDataSource(this.positions);
        this.mRecyclerView = this.binding.rcvDevice;
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext());
        linearLayoutManager.setOrientation(0);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.deviceAdapter = new c(this.deviceList);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.deviceAdapter);
        this.deviceAdapter.a(this);
        if (!this.deviceList.isEmpty()) {
            this.binding.setProfile(this.deviceList.get(this.selectDeviceIndex));
        }
        return this.binding.getRoot();
    }

    @Subscribe(threadMode=ThreadMode.MAIN, sticky=true)
    public void onLoadListResult(b b2) {
        if (b2.b().equals(NetworkDevice.class)) {
            this.deviceList = (ArrayList)b2.a();
            this.deviceAdapter.a(this.deviceList);
            this.binding.setProfile(this.deviceList.get(this.selectDeviceIndex));
        }
    }

    public void dismissAddDeviceWindow(View view) {
        this.getActivity().onBackPressed();
    }

    public void addDevice(View view) {
        String string2 = this.positions.get(this.positionSpinner.getSelectedIndex());
        NetworkDevice networkDevice = this.filterList != null ? this.filterList.get(this.selectDeviceIndex) : this.deviceList.get(this.selectDeviceIndex);
        networkDevice.setPosition(string2);
        Intent intent = new Intent();
        intent.putExtra("network_device", (Parcelable)networkDevice);
        intent.putExtra("add_device_index", this.typeSpinner.getSelectedIndex());
        this.getActivity().setResult(-1, intent);
        this.getActivity().finish();
    }

    private void filterDeviceByType(String string2) {
        this.selectDeviceIndex = 0;
        if ("\u5168\u90e8".equals(string2)) {
            this.deviceAdapter.a(this.deviceList);
            this.deviceAdapter.b(0);
            this.binding.setProfile(this.deviceAdapter.a(0));
            return;
        }
        this.filterList = new ArrayList();
        for (NetworkDevice networkDevice : this.deviceList) {
            if (!networkDevice.getDeviceType().contains(string2)) continue;
            this.filterList.add(networkDevice);
        }
        this.deviceAdapter.a(this.filterList);
        this.deviceAdapter.b(0);
        this.binding.setProfile(this.deviceAdapter.a(0));
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
        if (adapterView.getTag().toString() == TAG_SPINNER) {
            this.filterDeviceByType(this.deviceTypes.get(n2));
        }
    }

    @Override
    public void onItemClick(View view, int n2) {
        this.binding.setProfile(this.deviceAdapter.a(n2));
        this.selectDeviceIndex = n2;
        this.deviceAdapter.b(n2);
    }
}

