/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.fragment;

import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.komect.network.R;
import com.komect.network.app.fragment.BaseFragment;
import com.komect.network.app.widget.spinner.NiceSpinner;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.databinding.FragExistDeviceBinding;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ExistDeviceFragment
extends BaseFragment {
    public static final int RESULT_OK = -1;
    private FragExistDeviceBinding binding;
    private List<String> deviceTypes = new LinkedList<String>(Arrays.asList("\u8def\u7531\u5668", "\u7f51\u5173", "POE\u4ea4\u6362\u673a", "AP\u9762\u677f", "\u7535\u529b\u732b", "WiFi\u653e\u5927\u5668", "\u5176\u4ed6"));
    private List<String> positions = new LinkedList<String>(Arrays.asList("\u5ba2\u5385", "\u9910\u5385", "\u53a8\u623f", "\u4e3b\u5367", "\u6b21\u5367", "\u4e66\u623f", "\u5c0f\u5b69\u623f", "\u4e3b\u536b", "\u6b21\u536b", "\u9633\u53f0", "\u5176\u4ed6"));
    private List<String> bands = new LinkedList<String>(Arrays.asList("\u53cc\u9891", "2.4G", "5G"));
    private NiceSpinner typeSpinner;
    private NiceSpinner positionSpinner;
    private NiceSpinner bandSpinner;

    public static ExistDeviceFragment newInstance() {
        return new ExistDeviceFragment();
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.binding = (FragExistDeviceBinding)DataBindingUtil.inflate((LayoutInflater)layoutInflater, (int)R.layout.frag_exist_device, (ViewGroup)viewGroup, (boolean)false);
        this.binding.setFrag(this);
        this.typeSpinner = this.binding.spinnerType;
        this.typeSpinner.attachDataSource(this.deviceTypes);
        this.positionSpinner = this.binding.spinnerPosition;
        this.positionSpinner.attachDataSource(this.positions);
        this.bandSpinner = this.binding.spinnerBand;
        this.bandSpinner.attachDataSource(this.bands);
        return this.binding.getRoot();
    }

    public void dismissAddDeviceWindow(View view) {
        this.getActivity().onBackPressed();
    }

    public void addDevice(View view) {
        String string2 = this.deviceTypes.get(this.typeSpinner.getSelectedIndex());
        String string3 = this.positions.get(this.positionSpinner.getSelectedIndex());
        String string4 = this.bands.get(this.bandSpinner.getSelectedIndex());
        NetworkDevice networkDevice = new NetworkDevice();
        networkDevice.setDeviceName(string2);
        networkDevice.setDeviceType(string2);
        networkDevice.setPosition(string3);
        networkDevice.setBand(string4);
        networkDevice.setPower(this.binding.edtPower.getText().toString());
        Intent intent = new Intent();
        intent.putExtra("network_device", (Parcelable)networkDevice);
        intent.putExtra("add_device_index", this.typeSpinner.getSelectedIndex());
        this.getActivity().setResult(-1, intent);
        this.getActivity().finish();
    }
}

